/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.marketing.strategy.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.tpm.business.marketing.strategy.local.dto.MarketingStrategyApproveDto;
import com.biz.crm.tpm.business.marketing.strategy.local.dto.MarketingStrategyApproveSubmitDto;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategy;
import com.biz.crm.tpm.business.marketing.strategy.local.entity.MarketingStrategyItem;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyBudgetRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyItemRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.repository.MarketingStrategyRepository;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyBudgetService;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyItemService;
import com.biz.crm.tpm.business.marketing.strategy.local.service.MarketingStrategyService;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyApproveInfoVo;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyApproveProcessInfoVo;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyApproveVo;
import com.biz.crm.tpm.business.marketing.strategy.local.vo.MarketingStrategyBudgetSumVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyOutDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.log.MarketingStrategyLogEventDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.enums.StrategyStatusEnum;
import com.biz.crm.tpm.business.marketing.strategy.sdk.event.log.MarketingStrategyLogEventListener;
import com.biz.crm.tpm.business.marketing.strategy.sdk.pojo.MarketingStrategyItemBase;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategyLockSdkService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyItemVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto;
import com.biz.crm.tpm.business.year.budget.sdk.service.YearBudgetSdkService;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBatchBusinessService;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="marketingStrategyService")
public class MarketingStrategyServiceImpl
implements MarketingStrategyService {
    @Autowired(required=false)
    private MarketingStrategyRepository marketingStrategyRepository;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private MarketingStrategyItemRepository marketingStrategyItemRepository;
    @Autowired(required=false)
    private MarketingStrategyBudgetRepository marketingStrategyBudgetRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private MarketingStrategyItemService marketingStrategyItemService;
    @Autowired(required=false)
    private MarketingStrategyBudgetService marketingStrategyBudgetService;
    @Autowired(required=false)
    private ProcessBatchBusinessService processBatchBusinessService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private YearBudgetSdkService yearBudgetService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private ProcessBusinessMappingService processBusinessMappingService;
    @Autowired(required=false)
    private MarketingStrategyLockSdkService marketingStrategyLockSdkService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveSingleMarketingStrategy(MarketingStrategyDto dto, String itemCacheKey) {
        boolean update = !StringUtils.isBlank((CharSequence)dto.getId());
        List itemCacheList = this.marketingStrategyItemService.findCacheList(itemCacheKey);
        if (BooleanEnum.TRUE.getCapital().equals(dto.getMultipleStrategyAdd())) {
            this.saveMutiMarketingStrategy(dto, itemCacheList);
        } else {
            dto.setStrategySignStr("0");
            for (MarketingStrategyItemDto marketingStrategyItemDto : itemCacheList) {
                marketingStrategyItemDto.setStrategySignStr("0");
                marketingStrategyItemDto.setStrategyName(dto.getStrategyName());
                marketingStrategyItemDto.setStrategyTitle(dto.getStrategyTitle());
                marketingStrategyItemDto.setStrategyDesc(dto.getStrategyDesc());
                marketingStrategyItemDto.setIsCrossMonth(dto.getIsCrossMonth());
            }
            this.saveMarketingStrategy(dto, itemCacheList);
        }
        this.marketingStrategyItemService.clearCache(itemCacheKey);
        MarketingStrategyLogEventDto logEventDto = new MarketingStrategyLogEventDto();
        logEventDto.setNewest(dto);
        if (!update) {
            logEventDto.setOriginal(null);
            SerializableBiConsumer & Serializable onCreate = MarketingStrategyLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, MarketingStrategyLogEventListener.class, (SerializableBiConsumer)onCreate);
        } else {
            MarketingStrategy oldEntity = (MarketingStrategy)((Object)this.marketingStrategyRepository.getById((Serializable)((Object)dto.getId())));
            MarketingStrategyDto oldDto = (MarketingStrategyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)oldEntity, MarketingStrategyDto.class, HashSet.class, ArrayList.class, new String[0]);
            logEventDto.setOriginal(oldDto);
            SerializableBiConsumer & Serializable onUpdate = MarketingStrategyLogEventListener::onUpdate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, MarketingStrategyLogEventListener.class, (SerializableBiConsumer)onUpdate);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveMutiMarketingStrategy(MarketingStrategyDto dto, List<MarketingStrategyItemDto> itemCacheList) {
        boolean tempSave = Optional.ofNullable(dto.getTempSave()).orElse(false);
        if (tempSave) {
            this.marketingStrategyItemService.tempSaveCreateValidateList(dto, itemCacheList);
        } else {
            this.marketingStrategyItemService.createValidateList(dto, itemCacheList);
        }
        Map<String, List<MarketingStrategyItemDto>> strategyMap = itemCacheList.stream().collect(Collectors.groupingBy(MarketingStrategyItemBase::getStrategySignStr));
        HashMap dtoMap = Maps.newHashMap();
        for (Map.Entry<String, List<MarketingStrategyItemDto>> entry : strategyMap.entrySet()) {
            MarketingStrategyDto thisDto = (MarketingStrategyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entry.getValue().get(0), MarketingStrategyDto.class, HashSet.class, ArrayList.class, new String[0]);
            thisDto.setBusinessUnitCode(dto.getBusinessUnitCode());
            thisDto.setBusinessFormatCode(dto.getBusinessFormatCode());
            thisDto.setStrategyType(dto.getStrategyType());
            thisDto.setId(null);
            if (!tempSave) {
                this.createValidate(thisDto, entry.getValue(), false);
            }
            dtoMap.put(entry.getKey(), thisDto);
        }
        for (Map.Entry<String, List<MarketingStrategyItemDto>> entry : strategyMap.entrySet()) {
            this.saveMarketingStrategy((MarketingStrategyDto)dtoMap.get(entry.getKey()), entry.getValue(), false);
        }
    }

    @Override
    public Page<MonthBudgetVo> findMonthBudgetByConditions(Pageable pageable, MonthBudgetDto dto) {
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Page page = this.monthBudgetService.findByConditionsNoFilter(pageable, dto);
        this.updateMonthBudgetProperties(page.getRecords());
        return page;
    }

    @Override
    public Page<YearBudgetVo> findYearBudgetByConditions(Pageable pageable, YearBudgetDto dto) {
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Page page = this.yearBudgetService.findByConditions(pageable, dto);
        this.updateYearBudgetProperties(page.getRecords());
        return page;
    }

    private void updateMonthBudgetProperties(List<MonthBudgetVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (MonthBudgetVo monthBudgetVo : list) {
            if (null == monthBudgetVo.getAfterFreezeAmount()) {
                monthBudgetVo.setInitResolveAmount(BigDecimal.ZERO);
            }
            if (null == monthBudgetVo.getUsedStrategyAmount()) {
                monthBudgetVo.setUsedStrategyAmount(BigDecimal.ZERO);
            }
            monthBudgetVo.setUsableStrategyAmount(monthBudgetVo.getAfterFreezeAmount().subtract(monthBudgetVo.getUsedStrategyAmount()));
        }
    }

    private void updateYearBudgetProperties(List<YearBudgetVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (YearBudgetVo yearBudgetVo : list) {
            if (null == yearBudgetVo.getBudgetTotalAmount()) {
                yearBudgetVo.setBudgetTotalAmount(BigDecimal.ZERO);
            }
            if (null == yearBudgetVo.getUsedStrategyAmount()) {
                yearBudgetVo.setUsedStrategyAmount(BigDecimal.ZERO);
            }
            yearBudgetVo.setUsableStrategyAmount(yearBudgetVo.getBudgetTotalAmount().subtract(yearBudgetVo.getUsedStrategyAmount()));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveMarketingStrategy(MarketingStrategyDto dto, List<MarketingStrategyItemDto> itemDtoList) {
        this.saveMarketingStrategy(dto, itemDtoList, true);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveMarketingStrategy(MarketingStrategyDto dto, List<MarketingStrategyItemDto> itemDtoList, boolean createValidate) {
        this.saveMarketingStrategy(dto, itemDtoList, createValidate, true);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveMarketingStrategy(MarketingStrategyDto dto, List<MarketingStrategyItemDto> itemDtoList, boolean createValidate, boolean createValidateItem) {
        boolean update;
        boolean tempSave = Optional.ofNullable(dto.getTempSave()).orElse(false);
        if (createValidate && !tempSave) {
            this.createValidate(dto, itemDtoList, createValidateItem);
        }
        MarketingStrategy entity = null;
        boolean bl = update = !StringUtils.isBlank((CharSequence)dto.getId());
        if (!update) {
            entity = (MarketingStrategy)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, MarketingStrategy.class, HashSet.class, ArrayList.class, new String[0]));
            String code = (String)this.generateCodeService.generateCode("MS", 1, Integer.valueOf(6), 2L, TimeUnit.DAYS).get(0);
            entity.setStrategyCode(code);
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setTenantCode(TenantContextHolder.getTenantInfo().getTenantCode());
            entity.setIsValidate(!tempSave ? BooleanEnum.TRUE.getCapital() : BooleanEnum.FALSE.getCapital());
            entity.setStrategyStatus(StrategyStatusEnum.normal.getCode());
            this.marketingStrategyRepository.save((Object)entity);
            dto.setId(entity.getId());
        } else {
            MarketingStrategy oldEntity = (MarketingStrategy)((Object)this.marketingStrategyRepository.getById((Serializable)((Object)dto.getId())));
            if (!(ProcessStatusEnum.PREPARE.getKey().equals(oldEntity.getProcessStatus()) || ProcessStatusEnum.REJECT.getKey().equals(oldEntity.getProcessStatus()) || ProcessStatusEnum.RECOVER.getKey().equals(oldEntity.getProcessStatus()))) {
                throw new RuntimeException("\u53ea\u80fd\u7f16\u8f91\u5f85\u63d0\u4ea4\u3001\u9a73\u56de\u3001\u8ffd\u56de\u72b6\u6001\u7684\u6570\u636e\uff01");
            }
            dto.setStrategyCode(oldEntity.getStrategyCode());
            dto.setStrategySign(oldEntity.getStrategySign());
            dto.setTenantCode(oldEntity.getTenantCode());
            dto.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
            dto.setIsValidate(!tempSave ? BooleanEnum.TRUE.getCapital() : BooleanEnum.FALSE.getCapital());
            entity = (MarketingStrategy)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, MarketingStrategy.class, HashSet.class, ArrayList.class, new String[0]));
            this.marketingStrategyRepository.updateById((Object)entity);
        }
        this.marketingStrategyItemService.saveMarketingStrategyItemList(entity, update, itemDtoList, false, tempSave);
        this.marketingStrategyBudgetService.saveMarketingStrategyBudgetList(entity, update, itemDtoList);
    }

    private void createValidate(MarketingStrategyDto dto, List<MarketingStrategyItemDto> itemCacheList, boolean validateItem) {
        BigDecimal feeAmount;
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getStrategySignStr(), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u660e\u7ec6\u7b56\u7565\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        try {
            int strategySign = Integer.parseInt(dto.getStrategySignStr().trim());
            dto.setStrategySign(Integer.valueOf(strategySign));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u6807\u8bc6[" + dto.getStrategySignStr() + "]\u683c\u5f0f\u6709\u8bef,\u53ea\u80fd\u662f\u6574\u6570");
        }
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u65b0\u589e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getStrategyName(), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getStrategyType(), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getAttrOrgCode(), (String)"\u65b0\u589e\u65f6\uff0c\u5f52\u5c5e\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getStrategyTitle(), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setStrategyStatus(StrategyStatusEnum.normal.getCode());
        if (validateItem) {
            Validate.isTrue((!CollectionUtils.isEmpty(itemCacheList) ? 1 : 0) != 0, (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            this.marketingStrategyItemService.createValidateList(dto, itemCacheList);
        }
        if (!CollectionUtils.isEmpty(itemCacheList)) {
            BigDecimal feeAmount2 = itemCacheList.stream().map(MarketingStrategyItemBase::getFeeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            dto.setFeeAmount(feeAmount2);
            String strategyYear = itemCacheList.get(0).getStrategyYearMonth().substring(0, 4);
            dto.setStrategyYear(strategyYear);
            String beginStrategyYearMonth = itemCacheList.stream().map(MarketingStrategyItemBase::getStrategyYearMonth).min(Comparator.naturalOrder()).orElse(null);
            dto.setBeginStrategyYearMonth(beginStrategyYearMonth);
            String endStrategyYearMonth = itemCacheList.stream().map(MarketingStrategyItemBase::getStrategyYearMonth).max(Comparator.naturalOrder()).orElse(null);
            dto.setEndStrategyYearMonth(endStrategyYearMonth);
        }
        BigDecimal budgetFeeAmount = BigDecimal.ZERO;
        for (MarketingStrategyItemDto item : itemCacheList) {
            if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                MarketingStrategyBudgetDto budgetDto = new MarketingStrategyBudgetDto();
                budgetDto.setMonthBudgetCode(item.getMonthBudgetCode());
                budgetDto.setBudgetItemCode(item.getBudgetItemCode());
                budgetDto.setBudgetItemName(item.getBudgetItemName());
                budgetDto.setFeeBelongCode(item.getFeeBelongCode());
                budgetDto.setUseAmountStr(item.getFeeAmountStr());
                budgetDto.setUseAmount(item.getFeeAmount());
                budgetDto.setBusinessUnitCode(dto.getBusinessUnitCode());
                item.setBudgetShares((List)Lists.newArrayList((Object[])new MarketingStrategyBudgetDto[]{budgetDto}));
                continue;
            }
            for (MarketingStrategyBudgetDto budgetShare : item.getBudgetShares()) {
                budgetShare.setBusinessUnitCode(dto.getBusinessUnitCode());
                NumberStringDealUtil.validateNumberStrAndSet((String)budgetShare.getUseAmountStr(), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u660e\u7ec6\u8d39\u7528\u91d1\u989d", (boolean)false, arg_0 -> ((MarketingStrategyBudgetDto)budgetShare).setUseAmount(arg_0), BigDecimal.class);
                if (null == budgetShare.getUseAmount()) continue;
                budgetFeeAmount = budgetFeeAmount.add(budgetShare.getUseAmount());
            }
        }
        if (BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode()) && (feeAmount = Optional.ofNullable(dto.getFeeAmount()).orElse(BigDecimal.ZERO)).compareTo(budgetFeeAmount) != 0) {
            throw new RuntimeException("\u8d39\u7528\u91d1\u989d[" + feeAmount + "]\u4e0d\u7b49\u4e8e\u5b9e\u9645\u9884\u7b97\u4f7f\u7528\u91d1\u989d[" + budgetFeeAmount + "]");
        }
        ArrayList budgetDtos = Lists.newArrayList();
        for (MarketingStrategyItemDto itemDto : itemCacheList) {
            if (CollectionUtils.isEmpty((Collection)itemDto.getBudgetShares())) continue;
            budgetDtos.addAll(itemDto.getBudgetShares());
        }
        this.marketingStrategyBudgetService.useMonthBudget(budgetDtos, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteMarketingStrategy(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List marketingStrategies = this.marketingStrategyRepository.listByIds(ids);
        for (MarketingStrategy marketingStrategy : marketingStrategies) {
            Validate.isTrue((ProcessStatusEnum.PREPARE.getKey().equals(marketingStrategy.getProcessStatus()) || ProcessStatusEnum.REJECT.getKey().equals(marketingStrategy.getProcessStatus()) || ProcessStatusEnum.RECOVER.getKey().equals(marketingStrategy.getProcessStatus()) ? 1 : 0) != 0, (String)("\u8425\u9500\u7b56\u7565[" + marketingStrategy.getStrategyCode() + "]\u4e0d\u662f\u5f85\u63d0\u4ea4\u3001\u9a73\u56de\u6216\u8ffd\u56de\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664\uff01"), (Object[])new Object[0]);
        }
        this.marketingStrategyRepository.deleteByIds(ids);
        List<String> strategyCodes = marketingStrategies.stream().map(MarketingStrategy::getStrategyCode).collect(Collectors.toList());
        this.marketingStrategyItemRepository.deleteByStrategyCodes(strategyCodes);
        this.marketingStrategyBudgetService.deleteByStrategyCodes(strategyCodes);
        Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)marketingStrategies, MarketingStrategy.class, MarketingStrategyDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onDelete = MarketingStrategyLogEventListener::onDelete;
        for (MarketingStrategyDto dto : dtoList) {
            MarketingStrategyLogEventDto logEventDto = new MarketingStrategyLogEventDto();
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, MarketingStrategyLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    @Override
    public Page<MarketingStrategyVo> findByConditions(Pageable pageable, MarketingStrategyDto dto) {
        return this.marketingStrategyRepository.findByConditions(pageable, dto);
    }

    @Override
    public MarketingStrategyVo findById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        return this.marketingStrategyRepository.getVoById(id);
    }

    @Override
    public List<MarketingStrategyApproveInfoVo> findApproveInfoList(MarketingStrategyApproveDto dto) {
        MarketingStrategyDto searchDto = (MarketingStrategyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, MarketingStrategyDto.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList processStatusList = Lists.newArrayList();
        processStatusList.add(ProcessStatusEnum.PREPARE.getKey());
        processStatusList.add(ProcessStatusEnum.REJECT.getKey());
        processStatusList.add(ProcessStatusEnum.RECOVER.getKey());
        searchDto.setProcessStatusList((List)processStatusList);
        if (!StringUtils.isEmpty((CharSequence)dto.getAttrOrgCode())) {
            List<String> attrOrgCodeList = Arrays.asList(dto.getAttrOrgCode().split(","));
            List childOrgList = this.orgVoService.findAllChildrenByOrgCodes(attrOrgCodeList);
            searchDto.setAttrOrgCode(null);
            if (!CollectionUtils.isEmpty((Collection)childOrgList)) {
                searchDto.setAttrOrgCodeList(childOrgList.stream().map(OrgVo::getOrgCode).collect(Collectors.toList()));
            } else {
                searchDto.setAttrOrgCodeList(attrOrgCodeList);
            }
        } else {
            throw new RuntimeException("\u5f52\u5c5e\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> strategyCodeList = this.marketingStrategyRepository.findCodeList(searchDto);
        return this.findApproveInfoList(strategyCodeList);
    }

    @Override
    public List<MarketingStrategyApproveInfoVo> findApproveInfoList(List<String> strategyCodeList) {
        if (CollectionUtils.isEmpty(strategyCodeList)) {
            return Lists.newArrayList();
        }
        MarketingStrategyItemDto marketingStrategyItemDto = new MarketingStrategyItemDto();
        marketingStrategyItemDto.setStrategyCodeList(strategyCodeList);
        List<MarketingStrategyItem> list = this.marketingStrategyItemRepository.findList(marketingStrategyItemDto);
        return this.findApproveInfoListByItemList(list);
    }

    public List<MarketingStrategyApproveInfoVo> findApproveInfoListByItemList(List<MarketingStrategyItem> list) {
        Map<String, List<MarketingStrategyItem>> firstGroupMap = list.stream().collect(Collectors.groupingBy(marketingStrategyItem -> marketingStrategyItem.getBudgetItemCode() + marketingStrategyItem.getStrategyCode()));
        ArrayList result = Lists.newArrayList();
        for (Map.Entry<String, List<MarketingStrategyItem>> entry : firstGroupMap.entrySet()) {
            MarketingStrategyApproveInfoVo headVo = new MarketingStrategyApproveInfoVo();
            headVo.setStrategyOrgName("\u7b56\u7565\u5185\u5bb9");
            result.add(headVo);
            List<MarketingStrategyItem> firstGroupList = entry.getValue();
            Map<String, List<MarketingStrategyItem>> secondGroupMap = firstGroupList.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getStrategyOrgCode()).orElse("")));
            ArrayList resultGroupList = Lists.newArrayList();
            for (Map.Entry<String, List<MarketingStrategyItem>> secondEntry : secondGroupMap.entrySet()) {
                List<MarketingStrategyItem> secondGroupList = secondEntry.getValue();
                MarketingStrategyItem tempItem = secondGroupList.get(0);
                MarketingStrategyApproveInfoVo approveInfoVo = new MarketingStrategyApproveInfoVo();
                approveInfoVo.setBudgetItemCode(tempItem.getBudgetItemCode());
                approveInfoVo.setBudgetItemName(tempItem.getBudgetItemName());
                approveInfoVo.setStrategyCode(tempItem.getStrategyCode());
                approveInfoVo.setStrategyOrgName(tempItem.getStrategyOrgName());
                approveInfoVo.setFirstChannelCode(tempItem.getFirstChannelCode());
                approveInfoVo.setFirstChannelName(tempItem.getFirstChannelName());
                approveInfoVo.setActivityFormCode(tempItem.getActivityFormCode());
                approveInfoVo.setActivityFormName(tempItem.getActivityFormName());
                approveInfoVo.setActivityTypeCode(tempItem.getActivityTypeCode());
                approveInfoVo.setActivityTypeName(tempItem.getActivityTypeName());
                this.initApproveInfoMonthZero(approveInfoVo);
                for (MarketingStrategyItem marketingStrategyItem2 : secondGroupList) {
                    BigDecimal amount = Optional.ofNullable(marketingStrategyItem2.getFeeAmount()).orElse(BigDecimal.ZERO);
                    int month = Integer.parseInt(marketingStrategyItem2.getStrategyYearMonth().substring(5, 7));
                    switch (month) {
                        case 1: {
                            headVo.setJanuaryStr(marketingStrategyItem2.getStrategyName());
                            approveInfoVo.setJanuary(approveInfoVo.getJanuary().add(amount));
                            break;
                        }
                        case 2: {
                            headVo.setFebruaryStr(marketingStrategyItem2.getStrategyName());
                            approveInfoVo.setFebruary(approveInfoVo.getFebruary().add(amount));
                            break;
                        }
                        case 3: {
                            headVo.setMarchStr(marketingStrategyItem2.getStrategyName());
                            approveInfoVo.setMarch(approveInfoVo.getMarch().add(amount));
                            break;
                        }
                        case 4: {
                            headVo.setAprilStr(marketingStrategyItem2.getStrategyName());
                            approveInfoVo.setApril(approveInfoVo.getApril().add(amount));
                            break;
                        }
                        case 5: {
                            headVo.setMayStr(marketingStrategyItem2.getStrategyName());
                            approveInfoVo.setMay(approveInfoVo.getMay().add(amount));
                            break;
                        }
                        case 6: {
                            headVo.setJuneStr(marketingStrategyItem2.getStrategyName());
                            approveInfoVo.setJune(approveInfoVo.getJune().add(amount));
                            break;
                        }
                        case 7: {
                            headVo.setJulyStr(marketingStrategyItem2.getStrategyName());
                            approveInfoVo.setJuly(approveInfoVo.getJuly().add(amount));
                            break;
                        }
                        case 8: {
                            headVo.setAugustStr(marketingStrategyItem2.getStrategyName());
                            approveInfoVo.setAugust(approveInfoVo.getAugust().add(amount));
                            break;
                        }
                        case 9: {
                            headVo.setSeptemberStr(marketingStrategyItem2.getStrategyName());
                            approveInfoVo.setSeptember(approveInfoVo.getSeptember().add(amount));
                            break;
                        }
                        case 10: {
                            headVo.setOctoberStr(marketingStrategyItem2.getStrategyName());
                            approveInfoVo.setOctober(approveInfoVo.getOctober().add(amount));
                            break;
                        }
                        case 11: {
                            headVo.setNovemberStr(marketingStrategyItem2.getStrategyName());
                            approveInfoVo.setNovember(approveInfoVo.getNovember().add(amount));
                            break;
                        }
                        case 12: {
                            headVo.setDecemberStr(marketingStrategyItem2.getStrategyName());
                            approveInfoVo.setDecember(approveInfoVo.getDecember().add(amount));
                        }
                    }
                }
                resultGroupList.add(approveInfoVo);
            }
            result.addAll(resultGroupList);
            MarketingStrategyApproveInfoVo lastVo = new MarketingStrategyApproveInfoVo();
            lastVo.setStrategyOrgName("\u5408\u8ba1");
            this.initApproveInfoMonthZero(lastVo);
            for (MarketingStrategyApproveInfoVo approveInfoVo : resultGroupList) {
                lastVo.setJanuary(lastVo.getJanuary().add(approveInfoVo.getJanuary()));
                lastVo.setFebruary(lastVo.getFebruary().add(approveInfoVo.getFebruary()));
                lastVo.setMarch(lastVo.getMarch().add(approveInfoVo.getMarch()));
                lastVo.setApril(lastVo.getApril().add(approveInfoVo.getApril()));
                lastVo.setMay(lastVo.getMay().add(approveInfoVo.getMay()));
                lastVo.setJune(lastVo.getJune().add(approveInfoVo.getJune()));
                lastVo.setJuly(lastVo.getJuly().add(approveInfoVo.getJuly()));
                lastVo.setAugust(lastVo.getAugust().add(approveInfoVo.getAugust()));
                lastVo.setSeptember(lastVo.getSeptember().add(approveInfoVo.getSeptember()));
                lastVo.setOctober(lastVo.getOctober().add(approveInfoVo.getOctober()));
                lastVo.setNovember(lastVo.getNovember().add(approveInfoVo.getNovember()));
                lastVo.setDecember(lastVo.getDecember().add(approveInfoVo.getDecember()));
            }
            result.add(lastVo);
        }
        return result;
    }

    private void initApproveInfoMonthZero(MarketingStrategyApproveInfoVo vo) {
        vo.setJanuary(BigDecimal.ZERO);
        vo.setFebruary(BigDecimal.ZERO);
        vo.setMarch(BigDecimal.ZERO);
        vo.setApril(BigDecimal.ZERO);
        vo.setMay(BigDecimal.ZERO);
        vo.setJune(BigDecimal.ZERO);
        vo.setJuly(BigDecimal.ZERO);
        vo.setAugust(BigDecimal.ZERO);
        vo.setSeptember(BigDecimal.ZERO);
        vo.setOctober(BigDecimal.ZERO);
        vo.setNovember(BigDecimal.ZERO);
        vo.setDecember(BigDecimal.ZERO);
    }

    @Override
    public List<String> findToApprovalCodeList(MarketingStrategyApproveDto dto) {
        Validate.notBlank((CharSequence)dto.getStrategyType(), (String)"\u7b56\u7565\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getAttrOrgCode(), (String)"\u5f52\u5c5e\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getStrategyYear(), (String)"\u5e74\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MarketingStrategyDto searchDto = (MarketingStrategyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, MarketingStrategyDto.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList processStatusList = Lists.newArrayList();
        processStatusList.add(ProcessStatusEnum.PREPARE.getKey());
        processStatusList.add(ProcessStatusEnum.REJECT.getKey());
        processStatusList.add(ProcessStatusEnum.RECOVER.getKey());
        searchDto.setProcessStatusList((List)processStatusList);
        return this.marketingStrategyRepository.findCodeList(searchDto);
    }

    @Override
    public void updateProcessStatus(List<String> codeList, String processStatus) {
        this.marketingStrategyRepository.updateProcessStatus(codeList, processStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitApproval(List<String> toApprovalCodeList, MarketingStrategyApproveSubmitDto dto) {
        MarketingStrategyItemDto searchItemDto = new MarketingStrategyItemDto();
        searchItemDto.setStrategyCodeList(toApprovalCodeList);
        boolean lockSuccess = this.marketingStrategyLockSdkService.lock(toApprovalCodeList, TimeUnit.MINUTES, 3);
        Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        try {
            this.marketingStrategyBudgetService.useMonthBudgetByCodeList(toApprovalCodeList);
            ProcessBusinessDto processBusinessDto = dto.getProcessBusiness();
            processBusinessDto.setBusinessNoList(toApprovalCodeList);
            processBusinessDto.setBusinessCode("marketing_strategy");
            String businessNo = dto.getStrategyYear() + "-" + dto.getStrategyType() + "-" + dto.getBusinessFormatCode() + "-" + dto.getBusinessUnitCode() + "-" + dto.getAttrOrgCode() + System.currentTimeMillis();
            processBusinessDto.setBusinessNo(businessNo);
            ProcessBusinessVo processBusinessVo = this.processBatchBusinessService.processStart(processBusinessDto);
            this.marketingStrategyRepository.updateProcessStatusAndProcessNo(toApprovalCodeList, ProcessStatusEnum.COMMIT.getKey(), processBusinessVo.getProcessNo());
        }
        finally {
            this.marketingStrategyLockSdkService.unlock(toApprovalCodeList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processPass(ProcessStatusDto dto) {
        this.marketingStrategyRepository.updateProcessStatus(dto.getBusinessNoList(), dto.getProcessStatus());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processRejectAndRecover(ProcessStatusDto dto) {
        this.marketingStrategyBudgetService.returnMonthBudgetByCodeList(dto.getBusinessNoList());
        this.marketingStrategyRepository.updateProcessStatus(dto.getBusinessNoList(), dto.getProcessStatus());
    }

    @Override
    public MarketingStrategyApproveProcessInfoVo findApproveProcessInfo(String processNo) {
        ProcessBusinessMappingDto processBusinessMappingDto = new ProcessBusinessMappingDto();
        processBusinessMappingDto.setProcessNo(processNo);
        List processBusinessMappingVoList = this.processBusinessMappingService.findMultiByByConditions(processBusinessMappingDto);
        if (CollectionUtils.isEmpty((Collection)processBusinessMappingVoList)) {
            throw new RuntimeException("\u6d41\u7a0b\u6570\u636e\u6709\u8bef\uff01");
        }
        List businessNoList = processBusinessMappingVoList.stream().map(ProcessBusinessMappingVo::getBusinessNo).collect(Collectors.toList());
        MarketingStrategyItemDto marketingStrategyItemDto = new MarketingStrategyItemDto();
        marketingStrategyItemDto.setStrategyCodeList(businessNoList);
        List<MarketingStrategyItem> list = this.marketingStrategyItemRepository.findList(marketingStrategyItemDto);
        MarketingStrategyApproveProcessInfoVo processInfoVo = new MarketingStrategyApproveProcessInfoVo();
        MarketingStrategyDto marketingStrategyDto = new MarketingStrategyDto();
        marketingStrategyDto.setStrategyCode((String)businessNoList.get(0));
        List<MarketingStrategy> entityList = this.marketingStrategyRepository.findList(marketingStrategyDto);
        if (CollectionUtils.isEmpty(entityList)) {
            throw new RuntimeException("\u7b56\u7565\u4fe1\u606f\u6709\u8bef\uff01");
        }
        final MarketingStrategy marketingStrategy = entityList.get(0);
        processInfoVo.setApproveHead(new MarketingStrategyApproveVo(){
            {
                this.setStrategyType(marketingStrategy.getStrategyType());
                this.setStrategyYear(marketingStrategy.getStrategyYear());
                this.setBusinessFormatCode(marketingStrategy.getBusinessFormatCode());
                this.setBusinessUnitCode(marketingStrategy.getBusinessUnitCode());
                this.setAttrOrgCode(marketingStrategy.getAttrOrgCode());
                this.setAttrOrgName(marketingStrategy.getAttrOrgName());
            }
        });
        List<MarketingStrategyApproveInfoVo> infoList = this.findApproveInfoListByItemList(list);
        processInfoVo.setInfoList(infoList);
        return processInfoVo;
    }

    @Override
    public Page<MarketingStrategyItemVo> findApproveProcessItemPage(Pageable pageable, MarketingStrategyApproveDto dto) {
        List<String> strategyCodeList = this.findToApprovalCodeList(dto);
        if (CollectionUtils.isEmpty(strategyCodeList)) {
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u5f85\u63d0\u4ea4\u6570\u636e");
        }
        MarketingStrategyItemDto itemDto = new MarketingStrategyItemDto();
        itemDto.setStrategyCodeList(strategyCodeList);
        return this.marketingStrategyItemService.findByConditions(pageable, itemDto);
    }

    @Override
    public Page<MarketingStrategyItemVo> findApproveProcessItemPage(Pageable pageable, MarketingStrategyDto dto) {
        ProcessBusinessMappingDto processBusinessMappingDto = new ProcessBusinessMappingDto();
        processBusinessMappingDto.setProcessNo(dto.getProcessNo());
        List processBusinessMappingVoList = this.processBusinessMappingService.findMultiByByConditions(processBusinessMappingDto);
        if (CollectionUtils.isEmpty((Collection)processBusinessMappingVoList)) {
            throw new RuntimeException("\u6d41\u7a0b\u6570\u636e\u6709\u8bef\uff01");
        }
        List businessNoList = processBusinessMappingVoList.stream().map(ProcessBusinessMappingVo::getBusinessNo).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(businessNoList)) {
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u6d4b\u91cf\u6570\u636e");
        }
        MarketingStrategyItemDto itemDto = new MarketingStrategyItemDto();
        itemDto.setStrategyCodeList(businessNoList);
        return this.marketingStrategyItemService.findByConditions(pageable, itemDto);
    }

    @Override
    public List<MarketingStrategyBudgetSumVo> findApproveProcessSumInfo(String processNo) {
        ProcessBusinessMappingDto processBusinessMappingDto = new ProcessBusinessMappingDto();
        processBusinessMappingDto.setProcessNo(processNo);
        List processBusinessMappingVoList = this.processBusinessMappingService.findMultiByByConditions(processBusinessMappingDto);
        if (CollectionUtils.isEmpty((Collection)processBusinessMappingVoList)) {
            throw new RuntimeException("\u6d41\u7a0b\u6570\u636e\u6709\u8bef\uff01");
        }
        List businessNoList = processBusinessMappingVoList.stream().map(ProcessBusinessMappingVo::getBusinessNo).collect(Collectors.toList());
        MarketingStrategyItemDto itemDto = new MarketingStrategyItemDto();
        itemDto.setStrategyCodeList(businessNoList);
        List<MarketingStrategyBudgetDto> budgetList = this.marketingStrategyBudgetRepository.listByStrategyItem(itemDto);
        if (CollectionUtils.isEmpty(budgetList)) {
            return Lists.newArrayList();
        }
        List monthBudgetCodeList = budgetList.stream().map(MarketingStrategyBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(monthBudgetCodeList)) {
            return Lists.newArrayList();
        }
        List monthBudgetList = this.monthBudgetService.findByCodes(monthBudgetCodeList, null);
        Map monthBudgetMap = monthBudgetList.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
        HashMap resultMap = Maps.newHashMap();
        for (MarketingStrategyBudgetDto budgetDto : budgetList) {
            MonthBudgetVo monthBudgetVo = (MonthBudgetVo)monthBudgetMap.get(budgetDto.getMonthBudgetCode());
            String key = monthBudgetVo.getBudgetItemCode() + monthBudgetVo.getOrgCode() + monthBudgetVo.getYearMonthLy();
            MarketingStrategyBudgetSumVo sumVo = resultMap.computeIfAbsent(key, tempKey -> {
                MarketingStrategyBudgetSumVo tempVo = new MarketingStrategyBudgetSumVo();
                tempVo.setBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                tempVo.setBudgetItemName(monthBudgetVo.getBudgetItemName());
                tempVo.setYearMonthLy(monthBudgetVo.getYearMonthLy());
                tempVo.setOrgCode(monthBudgetVo.getOrgCode());
                tempVo.setOrgName(monthBudgetVo.getOrgName());
                tempVo.setAfterFreezeAmount(BigDecimal.ZERO);
                tempVo.setUsedStrategyAmount(BigDecimal.ZERO);
                tempVo.setTotalStrategyAmount(BigDecimal.ZERO);
                return tempVo;
            });
            sumVo.setAfterFreezeAmount(Optional.ofNullable(monthBudgetVo.getAfterFreezeAmount()).orElse(BigDecimal.ZERO).add(sumVo.getAfterFreezeAmount()));
            sumVo.setUsedStrategyAmount(Optional.ofNullable(monthBudgetVo.getUsedStrategyAmount()).orElse(BigDecimal.ZERO).add(sumVo.getUsedStrategyAmount()));
            sumVo.setTotalStrategyAmount(Optional.ofNullable(budgetDto.getUseAmount()).orElse(BigDecimal.ZERO).add(sumVo.getTotalStrategyAmount()));
        }
        return Lists.newArrayList(resultMap.values());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MarketingStrategyOutDto saveSingleMarketingStrategyNoCache(MarketingStrategyOutDto dto) {
        boolean update = !StringUtils.isBlank((CharSequence)dto.getId());
        List itemCacheList = dto.getItemCacheList();
        if (BooleanEnum.TRUE.getCapital().equals(dto.getMultipleStrategyAdd())) {
            this.saveMutiMarketingStrategy((MarketingStrategyDto)dto, itemCacheList);
        } else {
            dto.setStrategySignStr("0");
            for (MarketingStrategyItemDto marketingStrategyItemDto : itemCacheList) {
                marketingStrategyItemDto.setStrategySignStr("0");
                marketingStrategyItemDto.setStrategyName(dto.getStrategyName());
                marketingStrategyItemDto.setStrategyTitle(dto.getStrategyTitle());
                marketingStrategyItemDto.setStrategyDesc(dto.getStrategyDesc());
                marketingStrategyItemDto.setIsCrossMonth(dto.getIsCrossMonth());
            }
            this.saveMarketingStrategy((MarketingStrategyDto)dto, itemCacheList);
        }
        MarketingStrategyLogEventDto logEventDto = new MarketingStrategyLogEventDto();
        logEventDto.setNewest((MarketingStrategyDto)dto);
        if (!update) {
            logEventDto.setOriginal(null);
            SerializableBiConsumer & Serializable onCreate = MarketingStrategyLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, MarketingStrategyLogEventListener.class, (SerializableBiConsumer)onCreate);
        } else {
            MarketingStrategy oldEntity = (MarketingStrategy)((Object)this.marketingStrategyRepository.getById((Serializable)((Object)dto.getId())));
            MarketingStrategyDto oldDto = (MarketingStrategyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)oldEntity, MarketingStrategyDto.class, HashSet.class, ArrayList.class, new String[0]);
            logEventDto.setOriginal(oldDto);
            SerializableBiConsumer & Serializable onUpdate = MarketingStrategyLogEventListener::onUpdate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, MarketingStrategyLogEventListener.class, (SerializableBiConsumer)onUpdate);
        }
        return dto;
    }
}

