package com.biz.crm.tpm.business.marketing.strategy.sdk.dto;


import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

/**
 * 营销策略(MarketingStrategy)-预算
 *
 * @author wanghaojia
 * @since 2022-11-03 18:24:04
 */
@ApiModel(value = "MarketingStrategyBudgetDto", description = "营销策略-预算Dto")
@Getter
@Setter
public class MarketingStrategyBudgetDto extends TenantFlagOpDto {

    /**
     * 业务单元编码
     */
    @ApiModelProperty("业务单元编码")
    private String businessUnitCode;

    /**
     * 策略编码
     */
    @ApiModelProperty("策略编码")
    private String strategyCode;
    private List<String> strategyCodeList;
    /**
     * 策略类型
     */
    @ApiModelProperty("策略类型")
    private String strategyType;

    /**
     * 策略明细编码
     */
    @ApiModelProperty("策略明细编码")
    private String strategyItemCode;
    private List<String> strategyItemCodeList;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算编码", notes = "")
    private String monthBudgetCode;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    private String budgetItemName;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    private String feeBelongCode;

    private String feeSourceName;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    private String yearMonthLy;

    /**
     * 产品编码
     */
    @ApiModelProperty(value = "产品编码", notes = "")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(value = "产品名称", notes = "")
    private String productName;

    /**
     * 冻结后可用金额
     */
    @ApiModelProperty(value = "冻结后可用金额", notes = "")
    private BigDecimal afterFreezeAmount;

    /**
     * 已使用策略金额
     */
    @ApiModelProperty(value = "已使用策略金额", notes = "")
    private BigDecimal usedStrategyAmount;

    /**
     * 可用策略金额
     */
    @ApiModelProperty(value = "可用策略金额", notes = "")
    private BigDecimal usableStrategyAmount;

    /**
     * 本次使用金额
     */
    @ApiModelProperty(value = "本次使用金额", notes = "")
    private BigDecimal useAmount;

    /**
     * 本次使用金额-字符串，前端用
     */
    @ApiModelProperty(value = "本次使用金额-字符串，前端用", notes = "")
    private String useAmountStr;

    /**
     * 已占用金额
     */
    @ApiModelProperty(value = "已占用金额", notes = "")
    private BigDecimal usedAmount;

    /**
     * 是否完全承接
     */
    @ApiModelProperty("是否完全承接")
    private String fullAccept;

    @ApiModelProperty("区域编码")
    private String strategyOrgCode;

    @ApiModelProperty("区域名称")
    private String strategyOrgName;

    @ApiModelProperty("是否关闭")
    private String isClose;

}

