package com.biz.crm.tpm.business.marketing.strategy.sdk.dto;


import com.biz.crm.tpm.business.marketing.strategy.sdk.pojo.MarketingStrategyItemBase;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 营销策略(MarketingStrategyDto)
 *
 * @author wanghaojia
 * @since 2022-11-03 18:24:04
 */
@ApiModel(value = "MarketingStrategyItemDto", description = "营销策略明细")
@Getter
@Setter
public class MarketingStrategyItemDto extends MarketingStrategyItemBase {

    /**
     * 策略编码
     */
    @ApiModelProperty("策略编码集合")
    private List<String> strategyCodeList;

    @ApiModelProperty("策略明细编码集合")
    private List<String> strategyItemCodeList;


    @ApiModelProperty("是否选中，0否1是")
    private String checked;

    /**
     * 营销策略预算信息
     */
    @ApiModelProperty("营销策略预算信息")
    private List<MarketingStrategyBudgetDto> budgetShares;


    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String processStatus;

    /**
     * 附属部门集合
     */
    @ApiModelProperty("附属部门集合")
    private List<String> attrOrgCodeList;

    /**
     * 根据部门过滤数据时排除总部方案，默认为
     */
    private int attrOrgQueryExcludeHeadStrategy = 0;


}

