package com.biz.crm.tpm.business.marketing.strategy.sdk.enums;

import com.biz.crm.tpm.business.marketing.strategy.sdk.constant.MarketingStrategyModifyMqConstant;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 分子公司细案变更审批通过调用mq tag枚举
 * @author wanghaojia
 * @date 2023/1/16 21:00
 */
@AllArgsConstructor
@Getter
public enum MarketingStrategyModifyMqTagEnum {

    PASS_UPDATE_ORIGIN(MarketingStrategyModifyMqConstant.PASS_UPDATE_ORIGIN,"策略变更审批通过更新细案数据", PushType.code),
    //更新SD数据放在原数据更新完之后调用
//    PASS_UPDATE_SD(SubComActivityDetailPlanModifyPassMqTagConstant.PASS_UPDATE_SD,"分子活动细案变更审批通过更新sd活动数据", PushType.after_update_plan),
    ;

    private final String code;

    private final String name;

    private final PushType pushType;

    public enum PushType{
        code,after_update_origin
    }

}
