package com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto;


import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.pojo.MarketingStrategyItemModifyBase;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 营销策略(MarketingStrategyDto)
 *
 * @author wanghaojia
 * @since 2022-11-03 18:24:04
 */
@ApiModel(value = "MarketingStrategyItemDto", description = "营销策略变更明细")
@Getter
@Setter
public class MarketingStrategyItemModifyDto extends MarketingStrategyItemModifyBase {

    @ApiModelProperty("是否选中，0否1是")
    private String checked;

    /**
     * 营销策略预算信息
     */
    @ApiModelProperty("营销策略预算信息")
    private List<MarketingStrategyBudgetModifyDto> budgetShares;

    /**
     * 变更编码集合
     */
    @ApiModelProperty("变更编码集合")
    private List<String> modifyBusinessCodeList;

}

