package com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author wanghaojia
 * @date 2023/6/1 16:41
 */
@ApiModel(value = "MarketingStrategyModifyAdjustBudget", description = "营销策略")
@Getter
@Setter
public class MarketingStrategyModifyAdjustBudgetDto extends TenantFlagOpDto {

    /**
     * 变更编码
     */
    @ApiModelProperty("变更编码")
    private String modifyBusinessCode;

    /**
     * 变更编码集合
     */
    @ApiModelProperty("变更编码集合")
    private List<String> modifyBusinessCodeList;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算编码", notes = "")
    private String monthBudgetCode;

    /**
     * 年月-调入方
     */
    @ApiModelProperty(value = "年月-调入方", notes = "")
    private String yearMonthLy;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    private String budgetItemName;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    private String feeBelongCode;

    /**
     * 冻结后可用金额
     */
    @ApiModelProperty(value = "冻结后可用金额", notes = "")
    private BigDecimal afterFreezeAmount;

    /**
     * 已使用策略金额
     */
    @ApiModelProperty(value = "已使用策略金额", notes = "")
    private BigDecimal usedStrategyAmount;

    /**
     * 累计可用余额
     */
    @ApiModelProperty(value = "累计可用余额", notes = "")
    private BigDecimal accumulatedAvailableBalance;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算编码", notes = "")
    private String adjustOutMonthBudgetCode;

    /**
     * 年月-调出方
     */
    @ApiModelProperty(value = "年月-调出方", notes = "")
    private String adjustOutYearMonthLy;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    private String adjustOutBudgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    private String adjustOutBudgetItemName;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    private String adjustOutFeeBelongCode;

    /**
     * 冻结后可用金额
     */
    @ApiModelProperty(value = "冻结后可用金额", notes = "")
    private BigDecimal adjustOutAfterFreezeAmount;

    /**
     * 已使用策略金额
     */
    @ApiModelProperty(value = "已使用策略金额", notes = "")
    private BigDecimal adjustOutUsedStrategyAmount;
    /**
     * 累计可用余额（调出方）
     */
    @ApiModelProperty(value = "累计可用余额（调出方）", notes = "")
    private BigDecimal adjustOutAccumulatedAvailableBalance;

    /**
     * 调整金额
     */
    @ApiModelProperty(value = "调整金额", notes = "")
    private BigDecimal adjustAmount;

    /**
     * 调出说明
     */
    @ApiModelProperty(value = "调出说明", notes = "")
    private String adjustRemarks;

    @ApiModelProperty("是否选中，0否1是")
    private String checked;

    /**
     * 流程编号
     */
    @ApiModelProperty(value = "流程编号", notes = "")
    private String processNo;

}
