package com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.util.List;

/**
 * 营销策略待调整数据查询VO
 * @author wanghaojia
 * @date 2022/12/5 10:25
 */
@Data
@ApiModel(value = "营销策略待调整数据查询VO")
public class MarketingStrategyToModifyDto {

    @ApiModelProperty(name = "tenantCode", value = "租户编号")
    private String tenantCode;
    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    private String businessFormatCode;
    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元")
    private String businessUnitCode;
    /**
     * 归属部门编码
     */
    @ApiModelProperty("归属部门编码")
    private String attrOrgCode;

    /**
     * 策略年月
     */
    @ApiModelProperty("策略年月（多选逗号隔开）")
    private String strategyYearMonth;

    /**
     * 策略年月集合
     */
    private List<String> strategyYearMonthList;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码（多选逗号隔开）", notes = "")
    private String budgetItemCode;

    /**
     * 预算项目编码
     */
    private List<String> budgetItemCodeList;

    /**
     * 调整说明
     */
    @ApiModelProperty("调整说明")
    private String modifyExplain;

    /**
     * 创建人
     */
    @ApiModelProperty("创建人")
    private String createName;

    /**
     * 策略编码
     */
    @ApiModelProperty("策略编码")
    private String strategyCode;
    /**
     * 策略编码
     */
    @ApiModelProperty("策略编码")
    private List<String> strategyCodeList;

    /**
     * 策略编码
     */
    @ApiModelProperty("策略明细编码")
    private String strategyItemCode;

    @ApiModelProperty("策略明细编码")
    private List<String> strategyItemCodeList;


}
