package com.biz.crm.tpm.business.marketing.strategy.sdk.modify.pojo;


import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 营销策略调整Dto(MarketingStrategy)
 *
 * @author wanghaojia
 * @since 2022-11-05 15:57:30
 */
@ApiModel(value = "MarketingStrategyModifyBase", description = "营销策略调整基类")
@Getter
@Setter
public class MarketingStrategyModifyBase {


    @ApiModelProperty(name = "id", value = "主键ID")
    private String id;
    @ApiModelProperty(name = "createAccount", value = "创建人账号")
    private String createAccount;
    @ApiModelProperty(name = "createTime", value = "创建时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @ApiModelProperty(name = "createName", value = "创建人名称")
    private String createName;
    @ApiModelProperty(name = "modifyAccount", value = "更新人账号")
    private String modifyAccount;
    @ApiModelProperty(name = "modifyTime", value = "最后更新时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;
    @ApiModelProperty(name = "modifyName", value = "修改人名称")
    private String modifyName;
    @ApiModelProperty(name = "delFlag", value = "删除状态，003已删除，009未删除")
    private String delFlag;
    @ApiModelProperty(name = "enableStatus", value = "启禁用状态，003禁用，009启用")
    private String enableStatus;
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    @ApiModelProperty(name = "tenantCode", value = "租户编号")
    private String tenantCode;


    /**
     * 策略编码
     */
    @ApiModelProperty("变更策略编码")
    private String modifyBusinessCode;

    /**
     * 业态
     */
    @ApiModelProperty("业态 数据字典：mdm_business_format")
    private String businessFormatCode;
    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元")
    private String businessUnitCode;
    /**
     * 归属部门编码
     */
    @ApiModelProperty("归属部门编码")
    private String attrOrgCode;

    /**
     * 归属部门名称
     */
    @ApiModelProperty("归属部门名称")
    private String attrOrgName;

    /**
     * 多选逗号隔开
     */
    @ApiModelProperty("策略年月（多选逗号隔开）")
    private String strategyYearMonth;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码（多选逗号隔开）", notes = "")
    private String budgetItemCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目名称（多选逗号隔开）", notes = "")
    private String budgetItemName;

    /**
     * 调整说明
     */
    @ApiModelProperty("调整说明")
    private String modifyExplain;


    /**
     * 策略编码
     */
    @ApiModelProperty("策略编码")
    private String strategyCode;

    /**
     * 策略编码
     */
    @ApiModelProperty("策略明细编码")
    private String strategyItemCode;
}

