package com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author wanghaojia
 * @date 2023/6/1 16:41
 */
@ApiModel(value = "MarketingStrategyModifyAdjustBudget", description = "营销策略")
@Getter
@Setter
public class MarketingStrategyModifyAdjustBudgetVo extends TenantFlagOpVo {

    /**
     * 变更编码
     */
    @ApiModelProperty("变更编码")
    private String modifyBusinessCode;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算编码", notes = "")
    private String monthBudgetCode;

    /**
     * 年月-调入方
     */
    @ApiModelProperty(value = "年月-调入方", notes = "")
    private String yearMonthLy;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    private String budgetItemName;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    private String feeBelongCode;

    /**
     * 冻结后可用金额
     */
    @ApiModelProperty(value = "冻结后可用金额", notes = "")
    private BigDecimal afterFreezeAmount;

    /**
     * 已使用策略金额
     */
    @ApiModelProperty(value = "已使用策略金额", notes = "")
    private BigDecimal usedStrategyAmount;

    /**
     * 累计可用余额
     */
    @ApiModelProperty(value = "累计可用余额", notes = "")
    private BigDecimal accumulatedAvailableBalance;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算编码", notes = "")
    private String adjustOutMonthBudgetCode;

    /**
     * 年月-调出方
     */
    @ApiModelProperty(value = "年月-调出方", notes = "")
    private String adjustOutYearMonthLy;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    private String adjustOutBudgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    private String adjustOutBudgetItemName;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    private String adjustOutFeeBelongCode;

    /**
     * 冻结后可用金额
     */
    @ApiModelProperty(value = "冻结后可用金额", notes = "")
    private BigDecimal adjustOutAfterFreezeAmount;

    /**
     * 累计可用余额（调出方）
     */
    @ApiModelProperty(value = "累计可用余额（调出方）", notes = "")
    private BigDecimal adjustOutAccumulatedAvailableBalance;

    /**
     * 已使用策略金额
     */
    @ApiModelProperty(value = "已使用策略金额", notes = "")
    private BigDecimal adjustOutUsedStrategyAmount;

    /**
     * 调整金额
     */
    @ApiModelProperty(value = "调整金额", notes = "")
    private BigDecimal adjustAmount;

    /**
     * 调出说明
     */
    @ApiModelProperty(value = "调出说明", notes = "")
    private String adjustRemarks;

}
