package com.biz.crm.tpm.business.marketing.strategy.sdk.modify.vo;

import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.pojo.MarketingStrategyModifyBase;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author wanghaojia
 * @date 2022/12/6 11:00
 */
@Data
public class MarketingStrategyModifyVo extends MarketingStrategyModifyBase {

    /**
     * 策略调整的预算信息
     */
    private List<MarketingStrategyModifyAdjustBudgetVo> adjustBudgetList;

    @ApiModelProperty("变更编码")
    private String modifyBusinessCode;

    @ApiModelProperty("业态 数据字典：mdm_business_format")
    private String businessFormatCode;

    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元")
    private String businessUnitCode;

    @ApiModelProperty("归属部门编码")
    private String attrOrgCode;

    @ApiModelProperty("归属部门名称")
    private String attrOrgName;

    @ApiModelProperty("策略年月（多选逗号隔开）")
    private String strategyYearMonth;

    @ApiModelProperty(value = "预算项目编码（多选逗号隔开）", notes = "")
    private String budgetItemCode;

    @ApiModelProperty(value = "预算项目名称（多选逗号隔开）", notes = "")
    private String budgetItemName;

    @ApiModelProperty("调整说明")
    private String modifyExplain;

    @ApiModelProperty("流程编号")
    private String processNo;

    @ApiModelProperty("审批状态")
    private String processStatus;

    @ApiModelProperty("策略编码")
    private String strategyCode;

    @ApiModelProperty("策略明细编码")
    private String strategyItemCode;

}
