package com.biz.crm.tpm.business.marketing.strategy.sdk.pojo;


import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 营销策略(MarketingStrategy)-预算
 *
 * @author wanghaojia
 * @since 2022-11-03 18:24:04
 */
@ApiModel(value = "MarketingStrategyBudgetBase", description = "营销策略-预算基类")
@Getter
@Setter
public class MarketingStrategyBudgetBase {

    @ApiModelProperty(name = "id", value = "主键ID")
    private String id;
    @ApiModelProperty(name = "createAccount", value = "创建人账号")
    private String createAccount;
    @ApiModelProperty(name = "createTime", value = "创建时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @ApiModelProperty(name = "createName", value = "创建人名称")
    private String createName;
    @ApiModelProperty(name = "modifyAccount", value = "更新人账号")
    private String modifyAccount;
    @ApiModelProperty(name = "modifyTime", value = "最后更新时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;
    @ApiModelProperty(name = "modifyName", value = "修改人名称")
    private String modifyName;
    @ApiModelProperty(name = "delFlag", value = "删除状态，003已删除，009未删除")
    private String delFlag;
    @ApiModelProperty(name = "enableStatus", value = "启禁用状态，003禁用，009启用")
    private String enableStatus;
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    @ApiModelProperty(name = "tenantCode", value = "租户编号")
    private String tenantCode;


    /**
     * 策略编码
     */
    @ApiModelProperty("策略编码")
    private String strategyCode;

    /**
     * 策略明细编码
     */
    @ApiModelProperty("策略明细编码")
    private String strategyItemCode;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算编码", notes = "")
    private String monthBudgetCode;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    private String budgetItemName;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    private String feeBelongCode;

    private String feeSourceName;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    private String yearMonthLy;

    /**
     * 产品编码
     */
    @ApiModelProperty(value = "产品编码", notes = "")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(value = "产品名称", notes = "")
    private String productName;

    /**
     * 冻结后可用金额
     */
    @ApiModelProperty(value = "冻结后可用金额", notes = "")
    private BigDecimal afterFreezeAmount;

    /**
     * 已使用策略金额
     */
    @ApiModelProperty(value = "已使用策略金额", notes = "")
    private BigDecimal usedStrategyAmount;

    /**
     * 本次使用金额
     */
    @ApiModelProperty(value = "本次使用金额", notes = "")
    private BigDecimal useAmount;

    /**
     * 本次使用金额-字符串，前端用
     */
    @ApiModelProperty(value = "本次使用金额-字符串，前端用", notes = "")
    private String useAmountStr;

    /**
     * 可使用策略金额
     */
    @ApiModelProperty(value = "可使用策略金额", notes = "")
    private BigDecimal usableStrategyAmount;

    /**
     * 已占用金额
     */
    @ApiModelProperty(value = "已占用金额", notes = "")
    private BigDecimal usedAmount;

    /**
     * 剩余可用金额
     */
    @ApiModelProperty(value = "剩余可用金额", notes = "")
    private BigDecimal usableAmount;

}

