package com.biz.crm.tpm.business.marketing.strategy.sdk.pojo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author wanghaojia
 * @date 2023/2/12 14:21
 */
@ApiModel(value = "MarketingStrategyItemBase", description = "营销策略明细基类")
@Getter
@Setter
public class MarketingStrategyItemBase {

    @ApiModelProperty(name = "id", value = "主键ID")
    private String id;
    @ApiModelProperty(name = "createAccount", value = "创建人账号")
    private String createAccount;
    @ApiModelProperty(name = "createTime", value = "创建时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @ApiModelProperty(name = "createName", value = "创建人名称")
    private String createName;
    @ApiModelProperty(name = "modifyAccount", value = "更新人账号")
    private String modifyAccount;
    @ApiModelProperty(name = "modifyTime", value = "最后更新时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;
    @ApiModelProperty(name = "modifyName", value = "修改人名称")
    private String modifyName;
    @ApiModelProperty(name = "delFlag", value = "删除状态，003已删除，009未删除")
    private String delFlag;
    @ApiModelProperty(name = "enableStatus", value = "启禁用状态，003禁用，009启用")
    private String enableStatus;
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    @ApiModelProperty(name = "tenantCode", value = "租户编号")
    private String tenantCode;

    /**
     * 策略编码
     */
    @ApiModelProperty("策略编码")
    private String strategyCode;

    /**
     * 业态
     */
    @ApiModelProperty("业态")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    /**
     * 策略类型
     */
    @ApiModelProperty("策略类型")
    private String strategyType;

    /**
     * 策略明细编码
     */
    @ApiModelProperty("策略明细编码")
    private String strategyItemCode;
    /**
     * 策略名称
     */
    @ApiModelProperty("策略名称")
    private String strategyName;
    /**
     * 策略标识
     */
    @ApiModelProperty("策略标识")
    private Integer strategySign;
    private String strategySignStr;

    /**
     * 归属部门编码
     */
    @ApiModelProperty("归属部门编码")
    private String attrOrgCode;
    /**
     * 归属部门名称
     */
    @ApiModelProperty("归属部门名称")
    private String attrOrgName;

    /**
     * 区域编码
     */
    @ApiModelProperty("区域编码")
    private String strategyOrgCode;

    /**
     * 区域编码
     */
    @ApiModelProperty("区域erp编码")
    private String strategyOrgErpCode;

    /**
     * 区域名称
     */
    @ApiModelProperty("区域名称")
    private String strategyOrgName;
    /**
     * 一级管理渠道
     */
    @ApiModelProperty("一级管理渠道")
    private String firstChannelCode;
    /**
     * 一级管理渠道
     */
    @ApiModelProperty("一级管理渠道名称")
    private String firstChannelName;
    /**
     * 二级管理渠道
     */
    @ApiModelProperty("二级管理渠道")
    private String secondChannelCode;
    /**
     * 二级管理渠道
     */
    @ApiModelProperty("二级管理渠道名称")
    private String secondChannelName;

    @ApiModelProperty("分销渠道编码")
    private String distributionChannelCode;

    @ApiModelProperty("分销渠道名称")
    private String distributionChannelName;

    /**
     * 系统
     */
    @ApiModelProperty("系统")
    private String systemCode;
    /**
     * 策略主题
     */
    @ApiModelProperty("策略主题")
    private String strategyTitle;
    /**
     * 策略年月
     */
    @ApiModelProperty("策略年月")
    private String strategyYearMonth;
    /**
     * 策略开始年月
     */
    @ApiModelProperty("策略开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date beginDate;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String beginDateStr;
    /**
     * 策略结束年月
     */
    @ApiModelProperty("策略结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endDate;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String endDateStr;
    /**
     * 预算编码
     */
    @ApiModelProperty(value = "总部预算编码", notes = "")
    private String headMonthBudgetCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "总部预算项目编码", notes = "")
    private String headBudgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "总部预算项目名称", notes = "")
    private String headBudgetItemName;


    /**
     * 大区公投预算编码
     */
    @ApiModelProperty(value = "大区公投预算编码", notes = "")
    private String regionReferendumMonthBudgetCode;

    /**
     * 大区公投项目编码
     */
    @ApiModelProperty(value = "大区公投预算项目编码", notes = "")
    private String regionReferendumBudgetItemCode;

    /**
     * 大区公投预算项目名称
     */
    @ApiModelProperty(value = "大区公投预算项目名称", notes = "")
    private String regionReferendumBudgetItemName;

    /**
     * 大区公投预算编码
     */
    @ApiModelProperty(value = "大区自投预算编码", notes = "")
    private String regionAutomaticMonthBudgetCode;

    /**
     * 大区公投项目编码
     */
    @ApiModelProperty(value = "大区自投预算项目编码", notes = "")
    private String regionAutomaticBudgetItemCode;

    /**
     * 大区公投预算项目名称
     */
    @ApiModelProperty(value = "大区自投预算项目名称", notes = "")
    private String regionAutomaticBudgetItemName;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算编码", notes = "")
    private String monthBudgetCode;

    /**
     * 预算编码名称
     */
    @ApiModelProperty(value = "预算编码", notes = "")
    private String monthBudgetName;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    private String budgetItemName;

    /**
     * 归口
     */
    @ApiModelProperty("归口")
    private String feeBelongCode;
    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    private String activityTypeName;
    /**
     * 活动类型-前端用
     */
    @ApiModelProperty("活动类型-前端用")
    private String activityType;
    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    private String activityFormName;
    /**
     * 活动形式-前端用
     */
    @ApiModelProperty("活动形式-前端用")
    private String activityForm;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String productBrandName;
    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    private String productItemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    private String productItemName;
    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    private String productName;
    /**
     * 活动力度
     */
    @ApiModelProperty("活动力度")
    private String activityIntensity;
    /**
     * 活动场次
     */
    @ApiModelProperty("活动场次")
    private Integer activityNumber;
    private String activityNumberStr;
    /**
     * 数量
     */
    @ApiModelProperty("数量")
    private Integer quantity;
    private String quantityStr;
    /**
     * 费用金额（元）
     */
    @ApiModelProperty("费用金额（元）")
    private BigDecimal feeAmount;
    private String feeAmountStr;

    @ApiModelProperty("剩余可用策略金额")
    private BigDecimal usableAmount;

    /**
     * 总部承担金额
     */
    @ApiModelProperty("总部承担金额（元）")
    private BigDecimal headFeeAmount;
    /**
     *总部承担金额（元）-字符串，前端用
     */
    @ApiModelProperty("总部承担金额（元）-字符串，前端用")
    private String headFeeAmountStr;

    /**
     * 大区公投预算金额
     */
    @ApiModelProperty("大区公投预算金额（元）")
    private BigDecimal regionReferendumFeeAmount;
    /**
     *大区公投预算金额（元）-字符串，前端用
     */
    @ApiModelProperty("大区公投预算金额（元）-字符串，前端用")
    private String regionReferendumFeeAmountStr;

    /**
     * 大区自投预算金额
     */
    @ApiModelProperty("大区自投预算金额（元）")
    private BigDecimal regionAutomaticFeeAmount;
    /**
     *大区自投预算金额（元）-字符串，前端用
     */
    @ApiModelProperty("大区自投预算金额（元）-字符串，前端用")
    private String regionAutomaticFeeAmountStr;

    /**
     * 策略描述
     */
    @ApiModelProperty("策略描述")
    private String strategyDesc;

    /**
     * 预算分摊规则
     */
    @ApiModelProperty("预算分摊规则")
    private String budgetShareRule;

    /**
     * 控制系数
     */
    @ApiModelProperty(value = "控制系数")
    private String controlRatio;
    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;
    /**
     * 城市名称
     */
    @ApiModelProperty("城市名称")
    private String cityName;

    /**
     * 调整前版本号
     */
    @ApiModelProperty("调整前变更编码")
    private String currModifyBusinessCode;

    /**
     * 预算年月
     */
    @ApiModelProperty("预算年月")
    private String yearMonthLy;

    /**
     * 营销策略范围信息
     */
    @ApiModelProperty("营销策略范围信息")
    private List<MarketingStrategyItemScope> scopeList;


    /**
     * 是否跨月策略
     */
    @ApiModelProperty(name = "是否跨月策略", notes = "")
    private String isCrossMonth;

    @ApiModelProperty(name = "模版编码", notes = "")
    private String templateConfigCode;

    /**
     * 活动投入方向
     */
    @ApiModelProperty("活动投入方向")
    private String activityInputDirection;

    /**
     * 费用类型
     */
    @ApiModelProperty("费用类型")
    private String feeType;

    /**
     * 销量目标
     */
    @ApiModelProperty("销量目标")
    private BigDecimal salesGoalAmount;
    private String salesGoalAmountStr;

    /**
     * 费效比
     */
    @ApiModelProperty("费效比")
    private BigDecimal costEffectivenessRatio;


    /**
     * 是否关闭
     */
    @ApiModelProperty(name = "是否关闭", notes = "")
    private String isClose;

}
