package com.biz.crm.tpm.business.marketing.strategy.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.OperateMarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyBudgetVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 营销策略(MarketingStrategy)表服务接口-对外
 *
 * @author wanghaojia
 * @since 2022-10-25 17:07:55
 */
public interface MarketingStrategyBudgetSdkService {

    /**
     * 查询营销策略预算信息
     */
    List<MarketingStrategyBudgetDto> findListByConditions(MarketingStrategyBudgetDto dto);

    /**
     * 根据策略编码列举可以选择的预算编码
     * @param strategyCodes 策略编码
     */
    List<String> listBudgetCodeListByStrategyCodeList(List<String> strategyCodes);

    /**
     * 批量操作占用金额
     * @author wanghaojia
     * @date 2023/1/9 16:35
     **/
    void operateAmount(List<OperateMarketingStrategyBudgetDto> operateList);

    /**
     * 分页查询策略预算数据
     * @param pageable 分页参数
     * @param dto 查询属性
     */
    Page<MarketingStrategyBudgetVo> findByConditions(Pageable pageable, MarketingStrategyBudgetDto dto);

    void operateAmount(List<OperateMarketingStrategyBudgetDto> operateList, Map<String, BigDecimal> looseAmountMap);
}
