package com.biz.crm.tpm.business.marketing.strategy.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyItemVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 营销策略(MarketingStrategy)表服务接口-对外
 *
 * @author wanghaojia
 * @since 2022-10-25 17:07:55
 */
public interface MarketingStrategyItemSdkService {

    /**
     * 按条件查询营销策略
     * @param pageable 分页参数
     * @param dto 查询参数
     */
    Page<MarketingStrategyItemVo> findByConditions(Pageable pageable, MarketingStrategyItemDto dto);

    List<MarketingStrategyItemVo> findByItemCodes(List<String> itemCodes);



}
