package com.biz.crm.tpm.business.marketing.strategy.sdk.service;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * 营销策略(MarketingStrategy)表服务接口-对外
 *
 * @author wanghaojia
 * @since 2022-10-25 17:07:55
 */
public interface MarketingStrategyLockSdkService {

    /**
     * 加锁
     *
     * @param code
     * @param timeUnit
     * @param time
     * @return boolean
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-09-22 14:53
     */
    boolean lock(String code, TimeUnit timeUnit, int time);

    /**
     * 加锁
     *
     * @param codeList
     * @param timeUnit
     * @param time
     * @return boolean
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-09-22 14:53
     */
    boolean lock(List<String> codeList, TimeUnit timeUnit, int time);

    /**
     * 解锁
     *
     * @param code
     * @return boolean
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-09-22 14:53
     */
    void unlock(String code);

    /**
     * 解锁
     *
     * @param codeList
     * @return boolean
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-09-22 14:53
     */
    void unlock(List<String> codeList);
}
