package com.biz.crm.tpm.business.marketing.strategy.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyOutDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 营销策略(MarketingStrategy)表服务接口-对外
 *
 * @author wanghaojia
 * @since 2022-10-25 17:07:55
 */
public interface MarketingStrategySdkService {

    /**
     * 按条件查询营销策略
     * @param pageable 分页参数
     * @param dto 查询参数
     */
    Page<MarketingStrategyVo> findByConditions(Pageable pageable, MarketingStrategyDto dto);

    MarketingStrategyOutDto create(MarketingStrategyOutDto dto);

    MarketingStrategyOutDto update(MarketingStrategyOutDto dto);

    MarketingStrategyVo findById(String id);

    void delete(List<String> ids);

}
