package com.biz.crm.tpm.business.marketing.strategy.sdk.util;

import com.biz.crm.mn.common.base.util.DateUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.util.Date;

/**
 * 活动版本控制工具类-年月日
 * @author wanghaojia
 * @date 2022/12/26 10:20
 */
public class MnActivityVersionUtil {

    private static final String initNumber = "0001";

    /**
     * 初始化版本
     * @return 版本号
     */
    public static String initVersionCode(){
        return initVersionCode(null);
    }

    /**
     * 初始化版本
     * @param prefix 前缀
     * @return 版本号
     */
    public static String initVersionCode(String prefix){
        if (null == prefix){
            prefix = "";
        }else{
            prefix += ":";
        }
        String yyyyMMdd = DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH);
        return prefix + yyyyMMdd + ":" + initNumber;
    }

    /**
     * 版本号加一
     * @return 版本号
     */
    public static String incrVersionCode(String currVersionCode){
        String[] split = currVersionCode.split(":");
        String number = split[split.length - 1];
        String currYyyyMMdd = split[split.length -2];
        String yyyyMMdd = DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH);
        if (currYyyyMMdd.equals(yyyyMMdd)){
            //同一天就加一
            String newNumber = String.format("%04d",Integer.parseInt(number)+1);
            split[split.length-1] = newNumber;
        }else{
            split[split.length-2] = yyyyMMdd;
        }
        return String.join(":",split);
    }

}
