package com.biz.crm.tpm.business.marketing.strategy.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 营销策略内容导出vo
 *
 * @author chenlong
 * @date 2023/2/3
 */
@Data
@ApiModel(value = "MarketStrategyContentExportVo", description = "营销策略内容导出vo")
@CrmExcelExport
public class MarketStrategyContentExportVo extends CrmExcelVo {

    /**
     * 策略明细编码
     */
    @CrmExcelColumn("策略明细编码")
    private String strategyItemCode;

    /**
     * 活动分类编码
     */
    @CrmExcelColumn("活动分类编码")
    private String activityTypeCode;
    /**
     * 活动分类名称
     */
    @CrmExcelColumn("活动分类名称")
    private String activityTypeName;
    /**
     * 活动形式编码
     */
    @CrmExcelColumn("活动形式编码")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @CrmExcelColumn("活动形式名称")
    private String activityFormName;
    /**
     * 一级管理渠道
     */
    @CrmExcelColumn("一级管理渠道")
    private String firstChannelName;
    /**
     * 二级管理渠道
     */
    @CrmExcelColumn("二级管理渠道")
    private String secondChannelName;

    /**
     * 零售商
     */
    @CrmExcelColumn("零售商")
    private String systemCode;

    /**
     * 品牌名称
     */
    @CrmExcelColumn("品牌名称")
    private String productBrandName;
    /**
     * 活动力度
     */
    @CrmExcelColumn("活动力度")
    private String activityIntensity;
    /**
     * 活动场次
     */
    @CrmExcelColumn("活动场次")
    private Integer activityNumber;
    /**
     * 数量
     */
    @CrmExcelColumn("数量")
    private Integer quantity;
//    /**
//     * 总部预算编码
//     */
//    @CrmExcelColumn("总部预算编码")
//    private String headMonthBudgetCode;
//
//    /**
//     * 总部预算项目编码
//     */
//    @CrmExcelColumn("总部预算项目编码")
//    private String headBudgetItemCode;
//
//    /**
//     * 总部预算项目名称
//     */
//    @CrmExcelColumn("总部预算项目名称")
//    private String headBudgetItemName;

    /**
     * 预算编码
     */
    @CrmExcelColumn("预算编码")
    private String monthBudgetCode;

    /**
     * 预算项目编码
     */
    @CrmExcelColumn("预算项目编码")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @CrmExcelColumn("预算项目名称")
    private String budgetItemName;

    /**
     * 费用归口
     */
    @CrmExcelColumn("费用归口")
    private String feeBelongCode;

    /**
     * 策略年月
     */
    @CrmExcelColumn("策略年月")
    private String strategyYearMonth;

    /**
     * 策略开始时间
     */
    @CrmExcelColumn("策略开始时间")
    private String beginDateStr;

    /**
     * 策略结束时间
     */
    @CrmExcelColumn("策略结束时间")
    private String endDateStr;

    /**
     * 费用金额（元）
     */
    @CrmExcelColumn("费用金额（元）")
    private BigDecimal feeAmount;

    /**
     * 剩余可用金额
     */
    @CrmExcelColumn("剩余可用金额")
    private BigDecimal usableAmount;


}
