package com.biz.crm.tpm.business.marketing.strategy.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description:营销策略主列表明细导出vo
 * @Author qiancheng
 * @Date 2023/8/25
 */
@Data
@ApiModel(value = "MarketStrategyItemExportVo", description = "营销策略主列表明细导出vo")
@CrmExcelExport
public class MarketStrategyItemExportVo extends CrmExcelVo {

    @ApiModelProperty("审批状态")
    @CrmExcelColumn("审批状态")
    private String processStatus;

    @ApiModelProperty("业态")
    @CrmExcelColumn("业态")
    private String businessFormatCode;

    @ApiModelProperty("业务单元")
    @CrmExcelColumn("业务单元")
    private String businessUnitCode;

    @ApiModelProperty("归属部门编码")
    @CrmExcelColumn("归属部门编码")
    private String attrOrgCode;

    @ApiModelProperty("归属部门名称")
    @CrmExcelColumn("归属部门名称")
    private String attrOrgName;

    @ApiModelProperty("策略编码")
    @CrmExcelColumn("策略编码")
    private String strategyCode;

    @ApiModelProperty("策略名称")
    @CrmExcelColumn("策略名称")
    private String strategyName;

    @ApiModelProperty("策略明细编码")
    @CrmExcelColumn("策略明细编码")
    private String strategyItemCode;

    @ApiModelProperty("策略主题")
    @CrmExcelColumn("策略主题")
    private String strategyTitle;

    @ApiModelProperty("策略类型")
    @CrmExcelColumn("策略类型")
    private String strategyType;

    @ApiModelProperty("策略描述")
    @CrmExcelColumn("策略描述")
    private String strategyDesc;

    @ApiModelProperty(name = "createTime", value = "创建时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @CrmExcelColumn("创建时间")
    private Date createTime;

    @ApiModelProperty("创建人名称")
    @CrmExcelColumn("创建人名称")
    private String createName;

    @ApiModelProperty("启用状态")
    @CrmExcelColumn("启用状态")
    private String enableStatus;

    @ApiModelProperty("活动类型编码")
    @CrmExcelColumn("活动类型编码")
    private String activityTypeCode;

    @ApiModelProperty("活动类型名称")
    @CrmExcelColumn("活动类型名称")
    private String activityTypeName;

    @ApiModelProperty("活动形式编码")
    @CrmExcelColumn("活动形式编码")
    private String activityFormCode;

    @ApiModelProperty("活动形式名称")
    @CrmExcelColumn("活动形式名称")
    private String activityFormName;

    @ApiModelProperty("一级管理渠道名称")
    @CrmExcelColumn("一级管理渠道名称")
    private String firstChannelName;

    @ApiModelProperty("二级管理渠道名称")
    @CrmExcelColumn("二级管理渠道名称")
    private String secondChannelName;

    @ApiModelProperty("零售商")
    @CrmExcelColumn("零售商")
    private String systemName;

    @ApiModelProperty("零售商编码")
    private String systemCode;

    @ApiModelProperty("品牌名称")
    @CrmExcelColumn("品牌名称")
    private String productBrandName;

    @ApiModelProperty("活动力度")
    @CrmExcelColumn("活动力度")
    private String activityIntensity;

    @ApiModelProperty("活动场次")
    @CrmExcelColumn("活动场次")
    private Integer activityNumber;

    @ApiModelProperty("数量")
    @CrmExcelColumn("数量")
    private Integer quantity;

    @ApiModelProperty(value = "预算编码", notes = "")
    @CrmExcelColumn("预算编码")
    private String monthBudgetCode;

    @ApiModelProperty(value = "预算项目编码", notes = "")
    @CrmExcelColumn("预算项目编码")
    private String budgetItemCode;

    @ApiModelProperty(value = "预算项目名称", notes = "")
    @CrmExcelColumn("预算项目名称")
    private String budgetItemName;

    @ApiModelProperty("费用归口")
    @CrmExcelColumn("费用归口")
    private String feeBelongCode;

    @ApiModelProperty("预算年月")
    @CrmExcelColumn("预算年月")
    private String yearMonthLy;

    @ApiModelProperty("策略年月")
    @CrmExcelColumn("策略年月")
    private String strategyYearMonth;

    @ApiModelProperty("费用金额（元）")
    @CrmExcelColumn("费用金额（元）")
    private BigDecimal feeAmount;

    @ApiModelProperty("剩余可用策略金额")
    @CrmExcelColumn("剩余可用策略金额")
    private BigDecimal usableAmount;

}
