package com.biz.crm.tpm.business.marketing.strategy.sdk.vo;


import com.biz.crm.tpm.business.marketing.strategy.sdk.pojo.MarketingStrategyItemBase;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

/**
 * 营销策略(MarketingStrategyVo)
 *
 * @author wanghaojia
 * @since 2022-11-03 18:24:04
 */
@ApiModel(value = "MarketingStrategyItemVo", description = "营销策略明细")
@Getter
@Setter
public class MarketingStrategyItemVo extends MarketingStrategyItemBase {

    /**
     * 营销策略预算信息
     */
    @ApiModelProperty("营销策略预算信息")
    private List<MarketingStrategyBudgetVo> budgetShares;

    /**
     * 已使用金额（元）
     */
    @ApiModelProperty("已使用金额（元）")
    private BigDecimal usedAmount;

    /**
     * 剩余可用金额（元）
     */
    @ApiModelProperty("剩余可用金额（元）")
    private BigDecimal usableAmount;

    /**
     * 关联策略总金额（元）
     */
    @ApiModelProperty("关联策略总金额（元）")
    private BigDecimal strategyFeeAmount;
    /**
     * 关联策略已申请总金额（元）
     */
    @ApiModelProperty("关联策略已申请总金额（元）")
    private BigDecimal strategyUsedAmount;
    /**
     * 关联策略剩余可申请总金额（元）
     */
    @ApiModelProperty("关联策略剩余可申请总金额（元）")
    private BigDecimal strategyUsableAmount;

    /**
     * 冗余
     */
    @ApiModelProperty("是否完全承接")
    private String fullAccept;

}

