package com.biz.crm.tpm.business.marketing.strategy.sdk.vo;


import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 营销策略(MarketingStrategyVo)
 *
 * @author wanghaojia
 * @since 2022-11-05 15:57:30
 */
@ApiModel(value = "MarketingStrategyVo", description = "营销策略")
@Getter
@Setter
public class MarketingStrategyVo extends TenantFlagOpVo {
    /**
     * 策略编码
     */
    @ApiModelProperty("策略编码")
    private String strategyCode;
    /**
     * 策略名称
     */
    @ApiModelProperty("策略名称")
    private String strategyName;
    /**
     * 策略标识
     */
    @ApiModelProperty("策略标识")
    private Integer strategySign;
    private String strategySignStr;
    /**
     * 业态
     */
    @ApiModelProperty("业态")
    private String businessFormatCode;
    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元")
    private String businessUnitCode;
    /**
     * 归属部门编码
     */
    @ApiModelProperty("归属部门编码")
    private String attrOrgCode;
    /**
     * 归属部门名称
     */
    @ApiModelProperty("归属部门名称")
    private String attrOrgName;
    /**
     * 策略主题
     */
    @ApiModelProperty("策略主题")
    private String strategyTitle;
    /**
     * 策略类型
     */
    @ApiModelProperty("策略类型")
    private String strategyType;
    /**
     * 费用金额（元）
     */
    @ApiModelProperty("费用金额（元）")
    private BigDecimal feeAmount;
    private String feeAmountStr;
    /**
     * 已使用金额（元）
     */
    @ApiModelProperty("已使用金额（元）")
    private BigDecimal usedAmount;
    /**
     * 已关闭金额（元）
     */
    @ApiModelProperty("已关闭金额（元）")
    private BigDecimal closeAmount;
    /**
     * 剩余可用金额（元）
     */
    @ApiModelProperty("剩余可用金额（元）")
    private BigDecimal usableAmount;
    /**
     * 策略描述
     */
    @ApiModelProperty("策略描述")
    private String strategyDesc;
    /**
     * 流程编号
     */
    @ApiModelProperty("流程编号")
    private String processNo;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String processStatus;

    @ApiModelProperty("策略结束月份")
    private String endStrategyYearMonth;

    @ApiModelProperty("策略开始月份")
    private String beginStrategyYearMonth;


    /**
     * 是否跨月策略
     */
    @ApiModelProperty(name = "是否跨月策略", notes = "")
    private String isCrossMonth;

    @ApiModelProperty("是否已校验 Y:已校验，N:未校验")
    private String isValidate;

    @ApiModelProperty("是否完全承接")
    private String fullAccept;

    /**
     * 策略状态
     */
    @ApiModelProperty("策略状态")
    private String strategyStatus;

}

