package com.biz.crm.tpm.business.material.purchasing.order.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.promotion.material.feign.feign.PromotionMaterialFeign;
import com.biz.crm.mdm.business.promotion.material.sdk.vo.PromotionMaterialVO;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanPassMqTagConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanListDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityDetailPlanPassMqTagEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDetailDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.enums.TpmMaterialPurchasingOrderEnums;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.service.TpmMaterialPurchasingOrderService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author wanghaojia
 * @date 2023/1/16 19:59
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = ActivityDetailPlanConstant.TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag  定义在 *** 内 需要统一维护
        */
        selectorExpression = ActivityDetailPlanPassMqTagConstant.PASS_MATERIAL_PURCHASING_ORDER,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup  定义在 *** 内 需要统一维护
        */
        consumerGroup = ActivityDetailPlanPassMqTagConstant.PASS_MATERIAL_PURCHASING_ORDER + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class ActivityDetailPlanPassMaterialPurchasingOrderConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private TpmMaterialPurchasingOrderService tpmMaterialPurchasingOrderService;

    @Autowired(required = false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;
    @Autowired
    private PromotionMaterialFeign promotionMaterialFeign;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("活动细案审批通过推送物料采购单 order mq message received  : {}", message);
        if (Objects.isNull(message)
                || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }

        try {
            List<String> detailPlanCodeList = JSON.parseArray(message.getMsgBody(), String.class);

            List<ActivityDetailPlanDto> dtoList = activityDetailPlanSdkService.buildActivityDetailPlanParams(detailPlanCodeList);
            ActivityDetailPlanListDto dto = new ActivityDetailPlanListDto();
            dto.setList(dtoList);

            List<TpmMaterialPurchasingOrderDto> tpmMaterialPurchasingOrderDtoList = this.buildData(dto);
            if (CollectionUtils.isEmpty(tpmMaterialPurchasingOrderDtoList)) {
                return "消费成功.";
            }
            tpmMaterialPurchasingOrderService.saveBatch(tpmMaterialPurchasingOrderDtoList);
        }catch (Exception e){
            log.error(ActivityDetailPlanPassMqTagEnum.PASS_MATERIAL_PURCHASING_ORDER.getName()+"处理失败"+e.getMessage(),e);
            return "消费失败."+e.getMessage();
        }

        return "消费成功.";
    }

    public Object handleMessageOnce(MqMessageVo message) {
        if (Objects.isNull(message)
                || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }

        try {
            List<String> detailPlanCodeList = JSON.parseArray(message.getMsgBody(), String.class);

            List<ActivityDetailPlanDto> dtoList = activityDetailPlanSdkService.buildActivityDetailPlanParams(detailPlanCodeList);
            ActivityDetailPlanListDto dto = new ActivityDetailPlanListDto();
            dto.setList(dtoList);

            List<TpmMaterialPurchasingOrderDto> tpmMaterialPurchasingOrderDtoList = this.buildData(dto);
            if (CollectionUtils.isEmpty(tpmMaterialPurchasingOrderDtoList)) {
                return "消费成功.";
            }
            tpmMaterialPurchasingOrderService.saveBatch(tpmMaterialPurchasingOrderDtoList);
        }catch (Exception e){
            log.error(ActivityDetailPlanPassMqTagEnum.PASS_MATERIAL_PURCHASING_ORDER.getName()+"处理失败"+e.getMessage(),e);
            return "消费失败."+e.getMessage();
        }

        return "消费成功.";
    }

    private List<TpmMaterialPurchasingOrderDto> buildData(ActivityDetailPlanListDto listDto) {
        List<TpmMaterialPurchasingOrderDto> tpmMaterialPurchasingOrderDtoList = org.apache.commons.compress.utils.Lists.newArrayList();
        if (Objects.isNull(listDto)) {
            return tpmMaterialPurchasingOrderDtoList;
        }
        List<ActivityDetailPlanDto> activityDetailPlanDtoList = listDto.getList();
        if (CollectionUtils.isEmpty(activityDetailPlanDtoList)) {
            return tpmMaterialPurchasingOrderDtoList;
        }
        String tenantCode = TenantUtils.getTenantCode();

        activityDetailPlanDtoList.forEach(activityDetailPlanDto -> {
            // 活动分类为【物料】、填写物料编码的活动明细
            List<ActivityDetailPlanItemDto> itemList = activityDetailPlanDto.getItemList().stream()
                    .filter(e -> StringUtils.equals(YesOrNoEnum.NO.getCode(), e.getIsClose()))
                    .filter(e -> StringUtils.isNotEmpty(e.getMaterialCode()))
                    .filter(e -> "Z0008".equals(e.getActivityTypeCode()))
                    .collect(Collectors.toList());
            if (CollectionUtils.isEmpty(itemList)) {
                return;
            }
            // 根据物料关联的工商数量生成物料采购单
            List<String> materialCode = itemList.stream().map(ActivityDetailPlanItemBase::getMaterialCode).collect(Collectors.toList());
            Result<List<PromotionMaterialVO>> promotionMaterialVOResultList = promotionMaterialFeign.findByCodeList(materialCode);
            List<PromotionMaterialVO> promotionMaterialVOList = Lists.newArrayList();
            if (promotionMaterialVOResultList.isSuccess()) {
                promotionMaterialVOList.addAll(promotionMaterialVOResultList.getResult());
            }
            Map<String,PromotionMaterialVO> promotionMaterialVOMap = promotionMaterialVOList.stream()
                    .collect(Collectors.toMap(PromotionMaterialVO::getMaterialCode, Function.identity()));

            Map<String, List<ActivityDetailPlanItemDto>> dimensionToPlanItemDtoListMap = itemList.stream()
                    .collect(Collectors.groupingBy(ActivityDetailPlanItemBase::getMaterialCode));
            dimensionToPlanItemDtoListMap.forEach((key, value) -> {
                ActivityDetailPlanItemDto temp = value.get(0);
                PromotionMaterialVO promotionMaterialVO = promotionMaterialVOMap.get(key);
                if (Objects.nonNull(promotionMaterialVO) && StringUtils.isNotEmpty(promotionMaterialVO.getSupplierCode())) {
                    List<String> supplierCodes = Arrays.asList(promotionMaterialVO.getSupplierCode().split(","));
                    List<String> supplierNames = Arrays.asList(promotionMaterialVO.getSupplierName().split(","));
                    for (String supplierCode : supplierCodes) {
                        TpmMaterialPurchasingOrderDto dto = new TpmMaterialPurchasingOrderDto();
                        //dto.setOrderSource(TpmMaterialPurchasingOrderEnums.OrderSource.ACTIVITYDETAIL.getValue());
                        dto.setTenantCode(tenantCode);
                        dto.setBusinessUnitCode(temp.getBusinessUnitCode());
                        dto.setBusinessFormatCode(temp.getBusinessFormatCode());
                        dto.setStatus(TpmMaterialPurchasingOrderEnums.OrderStatus.TO_SUBMIT_10.getValue());
                        dto.setChangeStatus(TpmMaterialPurchasingOrderEnums.OrderChangeStatus.NOT_CHANGED.getValue());
                        dto.setSupplierCode(supplierCode);
                        int index = supplierCodes.indexOf(supplierCode);
                        dto.setSupplierName(index < supplierNames.size() ? supplierNames.get(index) : null);
                        dto.setMaterialCode(promotionMaterialVO.getMaterialCode());
                        dto.setMaterialName(promotionMaterialVO.getMaterialName());
                        dto.setCreateAccount(temp.getCreateAccount());
                        dto.setCreateName(temp.getCreateName());
                        dto.setModifyAccount(temp.getModifyAccount());
                        dto.setModifyName(temp.getModifyName());
                        tpmMaterialPurchasingOrderDtoList.add(dto);
                    }
                }
            });
        });
        return tpmMaterialPurchasingOrderDtoList;
    }

}
