package com.biz.crm.tpm.business.material.purchasing.order.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDetailDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.enums.TpmMaterialPurchasingOrderEnums;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.service.TpmMaterialPurchasingOrderService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.constant.SubComActivityDetailPlanConstant;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.constant.SubComActivityDetailPlanPassMqTagConstant;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums.SubComActivityDetailPlanPassMqTagEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author wanghaojia
 * @date 2023/1/16 19:59
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = SubComActivityDetailPlanConstant.TPM_SUB_COM_ACTIVITY_DETAIL_PLAN_MODIFY_PROCESS_PASS_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag  定义在 *** 内 需要统一维护
        */
        selectorExpression = SubComActivityDetailPlanPassMqTagConstant.MODIFY_PASS_MATERIAL_PURCHASING_ORDER,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup  定义在 *** 内 需要统一维护
        */
        consumerGroup = SubComActivityDetailPlanPassMqTagConstant.MODIFY_PASS_MATERIAL_PURCHASING_ORDER + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.ORDERLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class SubComActivityDetailPlanModifyPassMaterialPurchasingOrderConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private TpmMaterialPurchasingOrderService tpmMaterialPurchasingOrderService;

    @Autowired(required = false)
    private SubComActivityDetailPlanVoService subComActivityDetailPlanVoService;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("分子活动细案变更审批通过推送物料采购单 order mq message received  : {}", message);
        if (Objects.isNull(message)
                || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }

        try {
            List<String> businessNoList = JSON.parseArray(message.getMsgBody(), String.class);
            List<SubComActivityDetailPlanVo> voList = subComActivityDetailPlanVoService.findDetailPlanAndItemByPlanCode(businessNoList);
            List<TpmMaterialPurchasingOrderDetailDto> itemList = this.buildData(voList);
            if (CollectionUtils.isEmpty(itemList)) {
                return "消费成功.";
            }
            tpmMaterialPurchasingOrderService.updateBatch(itemList);
        } catch (Exception e) {
            log.error(SubComActivityDetailPlanPassMqTagEnum.PASS_MATERIAL_PURCHASING_ORDER.getName() + "处理失败" + e.getMessage(), e);
            return "消费失败." + e.getMessage();
        }

        return "消费成功.";
    }

    private List<TpmMaterialPurchasingOrderDetailDto> buildData(List<SubComActivityDetailPlanVo> voList) {
        List<TpmMaterialPurchasingOrderDetailDto> detailList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(voList)) {
            return detailList;
        }
        String tenantCode = TenantUtils.getTenantCode();
        Map<String, List<SubComActivityDetailPlanVo>> formatToSubComActivityDetailPlanVoList = voList.stream().filter(e -> StringUtils.isNotEmpty(e.getBusinessFormatCode())).collect(Collectors.groupingBy(SubComActivityDetailPlanVo::getBusinessFormatCode));
        formatToSubComActivityDetailPlanVoList.forEach((format, subComActivityDetailPlanVoList) -> {
            subComActivityDetailPlanVoList.forEach(activityDetailPlanVo -> {
                List<SubComActivityDetailPlanItemVo> itemList = activityDetailPlanVo.getItemList().stream()
                        .filter(e -> StringUtils.isNotEmpty(e.getSupplierCode()))
                        .filter(e -> Objects.nonNull(e.getQuantity()))
                        .filter(e -> Objects.nonNull(e.getMaterialPrice()))
                        .filter(e -> TpmMaterialPurchasingOrderEnums.IsTypeOfPurchaseNo.subsidiariesUnifiedPurchase.getValue().equals(e.getProcurementType()))
                        .collect(Collectors.toList());
                if (CollectionUtils.isEmpty(itemList)) {
                    return;
                }
                itemList.forEach(item -> {
                    TpmMaterialPurchasingOrderDetailDto detailDto = new TpmMaterialPurchasingOrderDetailDto();
                    detailDto.setTenantCode(tenantCode);
                    //detailDto.setActivityDetailCode(activityDetailPlanVo.getConstituentDetailPlanCode());
                    //detailDto.setActivityDetailName(activityDetailPlanVo.getConstituentDetailPlanName());
                    detailDto.setActivityDetailItemCode(item.getConstituentDetailPlanItemCode());
                    BigDecimal quantity = item.getQuantity();
                    //detailDto.setActivityDetailItemQuantity(quantity);
                    BigDecimal price = item.getMaterialPrice();
                    BigDecimal amount = quantity.multiply(price);
                    //detailDto.setActivityDetailItemAmount(amount);
                    detailDto.setCustomerCode(item.getCustomerCode());
                    detailDto.setCustomerName(item.getCustomerName());
                    detailDto.setMaterialCode(item.getMaterialCode());
                    detailDto.setMaterialName(item.getMaterialName());
                    //detailDto.setPrice(price);
                    detailList.add(detailDto);
                });
            });
        });
        return detailList;
    }

}
