package com.biz.crm.tpm.business.material.purchasing.order.local.consumer;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDetailDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.enums.TpmMaterialPurchasingOrderEnums;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.service.TpmMaterialPurchasingOrderService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.constant.SubComActivityDetailPlanConstant;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.constant.SubComActivityDetailPlanPassMqTagConstant;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanListDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums.SubComActivityDetailPlanPassMqTagEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author wanghaojia
 * @date 2023/1/16 19:59
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = SubComActivityDetailPlanConstant.TPM_SUB_COM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag  定义在 *** 内 需要统一维护
        */
        selectorExpression = SubComActivityDetailPlanPassMqTagConstant.PASS_MATERIAL_PURCHASING_ORDER,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup  定义在 *** 内 需要统一维护
        */
        consumerGroup = SubComActivityDetailPlanPassMqTagConstant.PASS_MATERIAL_PURCHASING_ORDER + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class SubComActivityDetailPlanPassMaterialPurchasingOrderConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private TpmMaterialPurchasingOrderService tpmMaterialPurchasingOrderService;

    @Autowired(required = false)
    private SubComActivityDetailPlanVoService subComActivityDetailPlanVoService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("分子活动细案审批通过推送物料采购单 order mq message received  : {}", message);
        if (Objects.isNull(message)
                || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }

        try {
            List<String> businessNoList = JSON.parseArray(message.getMsgBody(), String.class);
            List<SubComActivityDetailPlanVo> subDetailPlanList = subComActivityDetailPlanVoService.findDetailByPlanCodes(businessNoList);
            if (CollectionUtils.isEmpty(subDetailPlanList)) {
                log.error("分子活动细案审批通过推送物料采购单,未查询到分子活动细案!");
                return "未查询到分子活动细案！";
            }

            List<TpmMaterialPurchasingOrderDto> tpmMaterialPurchasingOrderDtoList = this.buildData(subDetailPlanList);
            if (CollectionUtils.isEmpty(tpmMaterialPurchasingOrderDtoList)) {
                log.error("分子活动细案审批通过推送物料采购单,构建物料采购单信息失败!");
                return "消费成功.";
            }
            log.info("分子活动细案审批通过推送物料采购单,开始保存活动细案的物料采购单");
            tpmMaterialPurchasingOrderService.saveBatch(tpmMaterialPurchasingOrderDtoList);
        }catch (Exception e){
            log.error(SubComActivityDetailPlanPassMqTagEnum.PASS_MATERIAL_PURCHASING_ORDER.getName()+"处理失败"+e.getMessage(),e);
            return "消费失败."+e.getMessage();
        }

        return "消费成功.";
    }

    private List<TpmMaterialPurchasingOrderDto> buildData(List<SubComActivityDetailPlanVo> subDetailPlanList) {
        List<TpmMaterialPurchasingOrderDto> tpmMaterialPurchasingOrderDtoList = Lists.newArrayList();
        if (Objects.isNull(subDetailPlanList)) {
            return tpmMaterialPurchasingOrderDtoList;
        }

        String tenantCode = TenantUtils.getTenantCode();
        subDetailPlanList.forEach(activityDetailPlanDto -> {
            List<SubComActivityDetailPlanItemVo> itemList = activityDetailPlanDto.getItemList().stream()
                    .filter(e -> StringUtils.isNotEmpty(e.getSupplierCode()))
                    .filter(e -> Objects.nonNull(e.getQuantity()))
                    .filter(e -> Objects.nonNull(e.getMaterialPrice()))
                    .filter(e -> TpmMaterialPurchasingOrderEnums.IsTypeOfPurchaseNo.subsidiariesUnifiedPurchase.getValue().equals(e.getProcurementType()))
                    .collect(Collectors.toList());
            if (CollectionUtils.isEmpty(itemList)) {
                log.error("分子活动细案审批通过推送物料采购单,构建物料采购单信息,分子细案:{},没有明细需生成物料采购单",activityDetailPlanDto.getConstituentDetailPlanCode());
                return;
            }
            Map<String, List<SubComActivityDetailPlanItemVo>> dimensionToPlanItemDtoListMap = itemList.stream()
                    .collect(Collectors.groupingBy(SubComActivityDetailPlanItemVo::getSupplierCode));
            dimensionToPlanItemDtoListMap.forEach((key, value) -> {
                SubComActivityDetailPlanItemVo temp = value.get(0);
                TpmMaterialPurchasingOrderDto dto = new TpmMaterialPurchasingOrderDto();
                //dto.setOrderSource(TpmMaterialPurchasingOrderEnums.OrderSource.SUBACTIVITYDETAIL.getValue());
                dto.setTenantCode(tenantCode);
                dto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
                dto.setBusinessFormatCode(activityDetailPlanDto.getBusinessFormatCode());
                dto.setStatus(TpmMaterialPurchasingOrderEnums.OrderStatus.TO_SUBMIT_10.getValue());
                dto.setSupplierCode(temp.getSupplierCode());
                dto.setSupplierName(temp.getSupplierName());
                dto.setChangeStatus(TpmMaterialPurchasingOrderEnums.OrderChangeStatus.NOT_CHANGED.getValue());
                List<TpmMaterialPurchasingOrderDetailDto> detailList = Lists.newArrayList();
                value.forEach(item -> {
                    TpmMaterialPurchasingOrderDetailDto detailDto = new TpmMaterialPurchasingOrderDetailDto();
                    detailDto.setTenantCode(tenantCode);
                    //detailDto.setActivityDetailCode(activityDetailPlanDto.getConstituentDetailPlanCode());
                    //detailDto.setActivityDetailName(activityDetailPlanDto.getConstituentDetailPlanName());
                    detailDto.setActivityDetailItemCode(item.getConstituentDetailPlanItemCode());
                    BigDecimal quantity = item.getQuantity();
                    //detailDto.setActivityDetailItemQuantity(quantity);
                    BigDecimal price = item.getMaterialPrice();
                    BigDecimal amount = quantity.multiply(price);
                    //detailDto.setActivityDetailItemAmount(amount);
                    detailDto.setCustomerCode(item.getCustomerCode());
                    detailDto.setCustomerName(item.getCustomerName());
                    detailDto.setMaterialCode(item.getMaterialCode());
                    detailDto.setMaterialName(item.getMaterialName());
                    //detailDto.setPrice(price);
                    detailList.add(detailDto);
                });
                dto.setDetailList(detailList);
                tpmMaterialPurchasingOrderDtoList.add(dto);
            });
        });
        return tpmMaterialPurchasingOrderDtoList;
    }

}
