package com.biz.crm.tpm.business.material.purchasing.order.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.material.purchasing.order.local.service.TpmMaterialPurchasingOrderDetailService;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDetailDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderDetailVo;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @CLASS_DESCRIBE: 物料采购单明细
 * @AUTHOR: create by zkey on 2023-11-06
 */
@Slf4j
@RestController
@RequestMapping("/v1/tpmMaterialPurchasingOrderDetail")
public class TpmMaterialPurchasingOrderDetailController
        extends MnPageCacheController<TpmMaterialPurchasingOrderDetailVo, TpmMaterialPurchasingOrderDetailDto> {

    @Autowired
    private TpmMaterialPurchasingOrderDetailService tpmMaterialPurchasingOrderDetailService;


    @ApiOperation(value = "分页查询可以提交审批的明细数据")
    @GetMapping("findSupplierApprovalList")
    public Result<Page<TpmMaterialPurchasingOrderDetailVo>> findSupplierApprovalList(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                                     @ApiParam(name = "dto", value = "TPM-物料采购单") TpmMaterialPurchasingOrderDto dto) {
        try {
            Page<TpmMaterialPurchasingOrderDetailVo> page = this.tpmMaterialPurchasingOrderDetailService.findSupplierApprovalList(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiModelProperty("提交审批审批流明细数据")
    @GetMapping("findSupplierSubmitApprovalDetailInfo")
    public Result<Page<TpmMaterialPurchasingOrderDetailVo>> findSupplierSubmitApprovalDetailInfo(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,TpmMaterialPurchasingOrderDetailDto dto){
        try {
            return Result.ok(this.tpmMaterialPurchasingOrderDetailService.findSupplierSubmitApprovalDetailInfo(pageable,dto));
        }catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    @ApiOperation("结案核销查看明细数据")
    @GetMapping("auditFindMaterialPurchasingOrderDetailByCondition")
    public Result<Page<TpmMaterialPurchasingOrderDetailVo>> auditFindMaterialPurchasingOrderDetailByCondition(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                                                              @ApiParam(name = "dto", value = "TPM-物料采购单明细") TpmMaterialPurchasingOrderDetailDto dto){
        try {
            return Result.ok(this.tpmMaterialPurchasingOrderDetailService.auditFindMaterialPurchasingOrderDetailByCondition(pageable,dto));
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

}
