package com.biz.crm.tpm.business.material.purchasing.order.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 物料采购单 实体
 *
 * @author duyiran
 * @create 2022-11-07 17:42
 */
@Data
@TableName("tpm_material_purchasing_order")
@Entity(name = "tpm_material_purchasing_order")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmMaterialPurchasingOrder", description = "TPM-物料采购单")
@org.hibernate.annotations.Table(appliesTo = "tpm_material_purchasing_order", comment = "TPM-物料采购单")
@Table(name = "tpm_material_purchasing_order", indexes = {@Index(name = "tpm_material_purchasing_order_index1", columnList = "tenant_code, code", unique = true)})
public class TpmMaterialPurchasingOrder extends TenantFlagOpEntity {

    /**
     * 流程编号
     */
    @ApiModelProperty("审批编号")
    @Column(name = "process_no", length = 128, columnDefinition = "VARCHAR(128) COMMENT '审批号'")
    private String processNo;

    /**
     * 编码
     */
    @ApiModelProperty(name = "编码", notes = "编码")
    @Column(name = "code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '编码'")
    private String code;

    /**
     * 状态[数据字典:tpm_material_purchasing_order_status]
     */
    @ApiModelProperty(name = "状态[数据字典:tpm_material_purchasing_order_status]", notes = "状态[数据字典:tpm_material_purchasing_order_status]")
    @Column(name = "status", length = 32, columnDefinition = "VARCHAR(32) COMMENT '状态[数据字典:tpm_material_purchasing_order_status]'")
    private String status;

    @ApiModelProperty(name = "审批状态", notes = "审批状态")
    @Column(name = "process_status", length = 32, columnDefinition = "VARCHAR(32) COMMENT '审批状态'")
    private String processStatus;

    /**
     * 调整状态
     */
    @ApiModelProperty(name = "调整状态", notes = "调整状态")
    @Column(name = "change_status", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '调整状态[tpm_material_purchasing_order_change_status]'")
    private String changeStatus;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    @Column(name = "business_format_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "业务单元[数据字典:mdm_business_unit]")
    @Column(name = "business_unit_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 供应商编码
     */
    @ApiModelProperty(name = "供应商编码", notes = "供应商编码")
    @Column(name = "supplier_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '供应商编码'")
    private String supplierCode;

    /**
     * 供应商名称
     */
    @ApiModelProperty(name = "供应商名称", notes = "供应商名称")
    @Column(name = "supplier_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '供应商名称'")
    private String supplierName;

    /**
     * 物料编码
     */
    @ApiModelProperty("物料编码")
    @Column(name = "material_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '物料编码'")
    private String materialCode;

    /**
     * 物料名称
     */
    @ApiModelProperty("物料名称")
    @Column(name = "material_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '物料名称'")
    private String materialName;

    /**
     * 合同单价
     */
    @ApiModelProperty("合同单价")
    @Column(name = "contract_price", length = 128, columnDefinition = "decimal(20,4) COMMENT '合同单价'")
    private BigDecimal contractPrice;

    /**
     * 采购单数量
     */
    @ApiModelProperty(name = "采购单数量", notes = "采购单数量")
    @Column(name = "quantity", columnDefinition = "decimal(20,4) COMMENT '采购单数量'")
    private BigDecimal quantity;

    /**
     * 采购单金额（元）
     */
    @ApiModelProperty(name = "采购单金额（元）", notes = "采购单金额（元）")
    @Column(name = "amount", nullable = true, length = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '采购单金额（元）'")
    private BigDecimal amount;

    /**
     * 发货数量
     */
    @ApiModelProperty(name = "发货数量", notes = "发货数量")
    @Column(name = "delivery_quantity", columnDefinition = "decimal(20,4) COMMENT '发货数量'")
    private BigDecimal deliveryQuantity;

    /**
     * 发货金额（元）
     */
    @ApiModelProperty(name = "发货金额（元）", notes = "发货金额（元）")
    @Column(name = "delivery_amount", length = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '发货金额（元）'")
    private BigDecimal deliveryAmount;

    /**
     * 签收数量
     */
    @ApiModelProperty(name = "签收数量", notes = "签收数量")
    @Column(name = "receiving_quantity", nullable = true, columnDefinition = "decimal(20,4) COMMENT '签收数量'")
    private BigDecimal receivingQuantity;

    /**
     * 签收金额（元）
     */
    @ApiModelProperty(name = "签收金额（元）", notes = "签收金额（元）")
    @Column(name = "receiving_amount", nullable = true, length = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '签收金额（元）'")
    private BigDecimal receivingAmount;

    /**
     * 创建人组织
     */
    @ApiModelProperty("创建人组织")
    @Column(name = "create_user_org", length = 128, columnDefinition = "VARCHAR(128) COMMENT '创建人组织'")
    private String createUserOrg;

    /**
     * 供应商组织
     */
    @ApiModelProperty("供应商组织")
    @Column(name = "supplier_org", length = 128, columnDefinition = "VARCHAR(128) COMMENT '供应商组织'")
    private String supplierOrg;

    @ApiModelProperty("供应商组织名称")
    @Column(name = "supplier_org_name", columnDefinition = "VARCHAR(255) COMMENT '供应商组织名称'")
    private String supplierOrgName;

    /**
     * 确认时间
     */
    @ApiModelProperty(name = "确认时间", notes = "确认时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "confirm_date", columnDefinition = "datetime COMMENT '确认时间'")
    private Date confirmDate;

    /**
     * 到货时间要求
     */
    @ApiModelProperty("到货时间要求")
    @Column(name = "delivery_date_ask", length = 128, columnDefinition = "VARCHAR(128) COMMENT '到货时间要求'")
    private String deliveryDateAsk;

    /**
     * 追样/签收时间
     */
    @ApiModelProperty("追样/签收时间")
    @Column(name = "node_receive_date", length = 128, columnDefinition = "VARCHAR(128) COMMENT '追样/签收时间'")
    private String nodeReceiveDate;

    /**
     * 模具完成时间
     */
    @ApiModelProperty("模具完成时间")
    @Column(name = "node_mold_date", length = 128, columnDefinition = "VARCHAR(128) COMMENT '模具完成时间'")
    private String nodeMoldDate;

    /**
     * 大货样送达时间
     */
    @ApiModelProperty("大货样送达时间")
    @Column(name = "node_sended_date", length = 128, columnDefinition = "VARCHAR(128) COMMENT '大货样送达时间'")
    private String nodeSendedDate;

    /**
     * 日产能时间
     */
    @ApiModelProperty("日产能时间")
    @Column(name = "node_capacity_date", length = 128, columnDefinition = "VARCHAR(128) COMMENT '日产能时间'")
    private String nodeCapacityDate;

    /**
     * 开始发货时间
     */
    @ApiModelProperty("开始发货时间")
    @Column(name = "node_start_delivery_date", length = 128, columnDefinition = "VARCHAR(128) COMMENT '开始发货时间'")
    private String nodeStartDeliveryDate;

    /**
     * 结案材料提交时间
     */
    @ApiModelProperty("结案材料提交时间")
    @Column(name = "node_end_case_date", length = 128, columnDefinition = "VARCHAR(128) COMMENT '结案材料提交时间'")
    private String nodeEndCaseDate;

    /**
     * 联系电话
     */
    @ApiModelProperty(name = "联系电话", notes = "联系电话")
    @Column(name = "phone", length = 20, columnDefinition = "VARCHAR(20) COMMENT '联系电话'")
    private String phone;

    /**
     * 物料基本工艺标准
     */
    @ApiModelProperty(name = "物料基本工艺标准",notes = "物料基本工艺标准")
    @Column(name = "material_base_standard", length = 255, columnDefinition = "VARCHAR(255) COMMENT '物料基本工艺标准'")
    private String materialBaseStandard;


    @ApiModelProperty("是否完全结案")
    @Column(name = "whole_audit", length = 32, columnDefinition = "VARCHAR(32) COMMENT '是否完全结案'")
    private String wholeAudit;

    @ApiModelProperty("已结案金额")
    @Column(name = "already_audit_amount",  columnDefinition = "decimal(20,4) COMMENT '已结案金额'")
    private BigDecimal alreadyAuditAmount;

    @ApiModelProperty("提交时间")
    @Column(name = "submit_time",  columnDefinition = "VARCHAR(32) COMMENT '提交时间'")
    private String submitTime;

    @ApiModelProperty("物料组编辑")
    @Column(name = "material_group_edit", length = 10, columnDefinition = "VARCHAR(10) COMMENT '物料组编辑'")
    private String materialGroupEdit;

    @ApiModelProperty("供应商编辑")
    @Column(name = "supplier_edit", length = 10, columnDefinition = "VARCHAR(10) COMMENT '供应商编辑'")
    private String supplierEdit;


    @Transient
    @TableField(exist = false)
    @ApiModelProperty("物料采购单明细列表")
    List<TpmMaterialPurchasingOrderDetail> detailList;
}
