package com.biz.crm.tpm.business.material.purchasing.order.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 物料采购单-核销文件表 实体
 *
 * @author duyiran
 * @create 2022-11-12 15:52
 */
@Data
@TableName("tpm_material_purchasing_order_audit_file")
@Entity(name = "tpm_material_purchasing_order_audit_file")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmMaterialPurchasingOrderAuditFile", description = "物料采购单-核销文件表 实体")
@org.hibernate.annotations.Table(appliesTo = "tpm_material_purchasing_order_audit_file", comment = "物料采购单-核销文件表 实体")
@Table(name = "tpm_material_purchasing_order_audit_file")
public class TpmMaterialPurchasingOrderAuditFile extends FileEntity {

    /**
     * 业务编码
     */
    @ApiModelProperty(name = "业务编码", notes = "业务编码")
    @Column(name = "business_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '采购单详情编码'")
    private String businessCode;

    /**
     * 业务名称
     */
    @ApiModelProperty(name = "业务名称", notes = "业务名称")
    @Column(name = "business_name", nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT '业务名称'")
    private String businessName;

    /**
     * 类型编码
     */
    @ApiModelProperty(name = "类型编码", notes = "类型编码")
    @Column(name = "type_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '类型编码'")
    private String typeCode;

}
