package com.biz.crm.tpm.business.material.purchasing.order.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author ：zy
 * @date ：Created in 2023/09/22
 * @description：物料采购单核销发票
 */
@ApiModel(value = "TpmMaterialPurchasingOrderAuditInvoice", description = "物料采购单核销发票")
@TableName("tpm_material_purchasing_order_audit_invoice")
@Getter
@Setter
@Entity(name = "tpm_material_purchasing_order_audit_invoice")
@org.hibernate.annotations.Table(appliesTo = "tpm_material_purchasing_order_audit_invoice", comment = "物料采购单核销发票")
@Table(name = "tpm_material_purchasing_order_audit_invoice")
public class TpmMaterialPurchasingOrderAuditInvoice extends TenantFlagOpEntity {

    @ApiModelProperty(name = "物料采购单编码", notes = "核销code")
    @Column(name = "code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '物料采购单编码'")
    private String code;

    @ApiModelProperty(name = "业态", notes = "业态")
    @Column(name = "business_format_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    @Column(name = "business_unit_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(name = "发票类型", notes = "发票类型")
    @Column(name = "invoice_type",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '发票类型'")
    private String invoiceType;

    @ApiModelProperty(name = "发票类型名称", notes = "发票类型名称")
    @Column(name = "invoice_type_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '发票类型名称'")
    private String invoiceTypeName;

    @ApiModelProperty(name = "发票代码", notes = "发票代码")
    @Column(name = "invoice_code",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '发票代码'")
    private String invoiceCode;

    @ApiModelProperty(name = "发票号码", notes = "发票号码")
    @Column(name = "invoice_number",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '发票号码'")
    private String invoiceNumber;

    @ApiModelProperty("发票明细id")
    @Column(name = "invoice_item_id",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '发票明细id'")
    private String invoiceItemId;

    @ApiModelProperty(name = "开票日期", notes = "开票日期")
    @Column(name = "invoice_date",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '开票日期'")
    private String invoiceDate;

    @ApiModelProperty(name = "校验码", notes = "校验码")
    @Column(name = "verify_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '校验码'")
    private String verifyCode;

    @ApiModelProperty("购买方名称")
    @Column(name = "buyer_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '购买方名称'")
    private String buyerName;

    @ApiModelProperty(name = "购买方纳税人识别号", notes = "购买方纳税人识别号")
    @Column(name = "buyer_taxpayer_identify_number",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '购买方纳税人识别号'")
    private String buyerTaxpayerIdentifyNumber;

    @ApiModelProperty(name = "购买方地址、电话", notes = "购买方地址、电话")
    @Column(name = "buyer_address_and_phone",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '购买方地址、电话'")
    private String buyerAddressAndPhone;

    @ApiModelProperty(name = "购买方开户行及账户", notes = "购买方开户行及账户")
    @Column(name = "buyer_open_account_bank_and_account",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '购买方开户行及账户'")
    private String buyerOpenAccountBankAndAccount;

    @ApiModelProperty(name = "销售方名称", notes = "销售方名称")
    @Column(name = "seller_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售方名称'")
    private String sellerName;

    @ApiModelProperty(name = "销售方纳税人识别号", notes = "销售方纳税人识别号")
    @Column(name = "seller_taxpayer_identify_number",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售方纳税人识别号'")
    private String sellerTaxpayerIdentifyNumber;

    @ApiModelProperty(name = "销售方地址、电话", notes = "销售方地址、电话")
    @Column(name = "seller_address_and_phone",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售方地址、电话'")
    private String sellerAddressAndPhone;

    @ApiModelProperty(name = "销售方方开户行及账户", notes = "销售方方开户行及账户")
    @Column(name = "seller_open_account_bank_and_account",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售方方开户行及账户'")
    private String sellerOpenAccountBankAndAccount;

    @ApiModelProperty(name = "发票金额（含税）", notes = "发票金额（含税）")
    @Column(name = "invoice_tax_amount",  columnDefinition = "decimal(24,6) COMMENT '发票金额（含税）'")
    private BigDecimal invoiceTaxAmount;

    @ApiModelProperty(name = "发票金额（未税）", notes = "发票金额（未税）")
    @Column(name = "invoice_amount",  columnDefinition = "decimal(24,6) COMMENT '发票金额（未税）'")
    private BigDecimal invoiceAmount;

    @ApiModelProperty(name = "税额（元）", notes = "税额（元）")
    @Column(name = "tax_amount",  columnDefinition = "decimal(24,6) COMMENT '税额（元）'")
    private BigDecimal taxAmount;

    @ApiModelProperty(name = "税率", notes = "税率")
    @Column(name = "tax_rate",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '税率'")
    private String taxRate;

    @ApiModelProperty(name = "税费科目", notes = "税费科目")
    @Column(name = "tax_subject",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '税费科目'")
    private String taxSubject;

    @ApiModelProperty(name = "税费科目名称", notes = "税费科目名称")
    @Column(name = "tax_subject_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '税费科目名称'")
    private String taxSubjectName;

    @ApiModelProperty("进转出金额")
    @Column(name = "change_amount", columnDefinition = "decimal(24,6) COMMENT '进转出金额'")
    private BigDecimal changeAmount;

    @ApiModelProperty(name = "活动明细编码", notes = "活动明细编码")
    @Column(name = "activity_detail_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动明细编码'")
    private String activityDetailCode;

    @ApiModelProperty(name = "发票使用金额")
    @Column(name = "invoice_use_amount",  columnDefinition = "decimal(24,6) COMMENT '发票使用金额'")
    private BigDecimal invoiceUseAmount;

    @ApiModelProperty(name = "使用金额税额")
    @Column(name = "use_amount_tax",  columnDefinition = "decimal(24,6) COMMENT '使用金额税额'")
    private BigDecimal useAmountTax;

    @ApiModelProperty(name = "使用金额未税")
    @Column(name = "use_amount_not_tax",  columnDefinition = "decimal(24,6) COMMENT '使用金额未税'")
    private BigDecimal useAmountNotTax;

    @ApiModelProperty(name = "税差")
    @Column(name = "tax_rates",  columnDefinition = "decimal(24,6) COMMENT '税差'")
    private BigDecimal taxRates;

    @ApiModelProperty("货物或应税劳务名称")
    @Column(name = "goods_taxable_name", length = 64, columnDefinition = "varchar(128) COMMENT '货物或应税劳务名称'")
    private String goodsTaxableName;
}
