package com.biz.crm.tpm.business.material.purchasing.order.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 物料采购单-明细表 实体
 *
 * @author duyiran
 * @create 2022-11-12 15:52
 */
@Data
@TableName("tpm_material_purchasing_order_detail")
@Entity(name = "tpm_material_purchasing_order_detail")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmMaterialPurchasingOrderDetail", description = "TPM-物料采购单-明细表")
@org.hibernate.annotations.Table(appliesTo = "tpm_material_purchasing_order_detail", comment = "TPM-物料采购单-明细表")
@Table(name = "tpm_material_purchasing_order_detail", indexes = {@Index(name = "tpm_material_purchasing_order_detail_index1", columnList = "tenant_code, code, customer_code, material_code", unique = true)})
public class TpmMaterialPurchasingOrderDetail extends TenantFlagOpEntity {

    /**
     * 流程编号
     */
    @ApiModelProperty("审批编号")
    @Column(name = "process_no", length = 128, columnDefinition = "VARCHAR(128) COMMENT '审批号'")
    private String processNo;
    /**
     * 审批状态
     */
    @ApiModelProperty(name = "审批状态", notes = "审批状态")
    @Column(name = "detail_status", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '审批状态'")
    private String detailStatus;

    /**
     * 采购单编码
     */
    @ApiModelProperty(name = "采购单编码", notes = "采购单编码")
    @Column(name = "code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '采购单编码'")
    private String code;

    /**
     * 采购单详情编码
     */
    @ApiModelProperty(name = "采购单详情编码", notes = "采购单详情编码")
    @Column(name = "detail_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '采购单详情编码'")
    private String detailCode;

    /**
     * 采购单明细编码
     */
    @ApiModelProperty(name = "采购单明细编码", notes = "采购单明细编码")
    @Column(name = "sub_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '采购单明细编码'")
    private String subCode;

    /**
     * 活动细案明细编码
     */
    @ApiModelProperty(name = "活动细案明细编码", notes = "活动细案明细编码")
    @Column(name = "activity_detail_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '活动细案明细编码'")
    private String activityDetailItemCode;

    /**
     * 活动细案编码
     */
    @ApiModelProperty(name = "活动细案编码", notes = "活动细案编码")
    @Column(name = "activity_detail_plan_code", length = 64, columnDefinition = "varchar(64) COMMENT '活动细案编码'")
    private String activityDetailPlanCode;

    /**
     * 活动细案名称
     */
    @ApiModelProperty(name = "活动细案名称", notes = "活动细案名称")
    @Column(name = "activity_detail_plan_name", length = 128, columnDefinition = "varchar(128) COMMENT '活动细案名称'")
    private String activityDetailPlanName;

    /**
     * 活动细案调整状态
     */
    @ApiModelProperty(name = "活动细案调整状态", notes = "活动细案调整状态")
    @Column(name = "activity_detail_change_status",length = 32, columnDefinition = "varchar(32) COMMENT '活动细案调整状态'")
    private String activityDetailChangeStatus;

    /**
     * 签收状态
     */
    @ApiModelProperty(name = "签收状态", notes = "签收状态")
    @Column(name = "receiving_status",columnDefinition = "varchar(32) COMMENT '签收状态'")
    private String receivingStatus;

    /**
     * 销售部门
     */
    @ApiModelProperty(name = "销售部门" ,notes = "销售部门")
    @Column(name = "sales_org_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售部门 '")
    private String salesOrgName;

    /**
     * 销售部门编码
     */
    @ApiModelProperty(name = "销售部门", notes = "销售部门编码")
    @Column(name = "sales_org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售部门编码 '")
    private String salesOrgCode;

    /**
     * 送货市场
     */
    @ApiModelProperty(name = "送货市场",notes = "送货市场")
    @Column(name = "delivery_dealer", length = 32, columnDefinition = "VARCHAR(64) COMMENT '送货市场 '")
    private String deliveryDealer;

    /**
     * 物料使用品类
     */
    @ApiModelProperty(name = "物料使用品类",notes = "物料使用品类")
    @Column(name = "material_category", length = 32, columnDefinition = "VARCHAR(64) COMMENT '物料使用品类 '")
    private String materialCategory;

    /**
     * 供应商编码
     */
    @ApiModelProperty(name = "供应商编码", notes = "供应商编码")
    @Column(name = "supplier_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '供应商编码'")
    private String supplierCode;

    /**
     * 供应商名称
     */
    @ApiModelProperty(name = "供应商名称", notes = "供应商名称")
    @Column(name = "supplier_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '供应商名称'")
    private String supplierName;

    /**
     * 物料编码
     */
    @ApiModelProperty(name = "物料编码", notes = "物料编码")
    @Column(name = "material_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '物料编码'")
    private String materialCode;

    /**
     * 物料名称
     */
    @ApiModelProperty(name = "物料名称", notes = "物料名称")
    @Column(name = "material_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '物料名称'")
    private String materialName;

    /**
     * 装箱数
     */
    @ApiModelProperty(name = "装箱数", notes = "装箱数")
    @Column(name = "packing_box_number", length = 128, columnDefinition = "VARCHAR(128) COMMENT '装箱数'")
    private BigDecimal packingBoxNumber;

    /**
     * 单位
     */
    @ApiModelProperty(name = "单位",notes = "单位")
    @Column(name = "unit", length = 32, columnDefinition = "VARCHAR(32) COMMENT '单位'")
    private String unit;

    /**
     * 物料基本工艺标准
     */
    @ApiModelProperty(name = "物料基本工艺标准",notes = "物料基本工艺标准")
    @Column(name = "material_base_standard", length = 512, columnDefinition = "VARCHAR(512) COMMENT '物料基本工艺标准'")
    private String materialBaseStandard;

    /**
     * 采购数量
     */
    @ApiModelProperty(name = "采购数量",notes = "采购数量")
    @Column(name = "purchasing_quantity", length = 20, columnDefinition = "decimal(20,4) COMMENT '采购数量'")
    private BigDecimal purchasingQuantity;

    /**
     * 金额
     */
    @ApiModelProperty(name = "金额", notes = "金额")
    @Column(name = "amount", nullable = true, length = 20, columnDefinition = "decimal(20,6) COMMENT '金额'")
    private BigDecimal amount;

    @ApiModelProperty("合同单价")
    @Column(name = "contract_price", length = 128, columnDefinition = "decimal(20,4) COMMENT '合同单价'")
    private BigDecimal contractPrice;

    /**
     * 发货单位
     */
    @ApiModelProperty(name = "发货单位",notes = "发货单位")
    @Column(name = "delivery_company", length = 64, columnDefinition = "VARCHAR(64) COMMENT '发货单位'")
    private String deliveryCompany;

    /**
     * 微信号
     */
    @ApiModelProperty(name = "微信号",notes = "微信号")
    @Column(name = "weixin_no", length = 64, columnDefinition = "VARCHAR(64) COMMENT '微信号'")
    private String weixinNo;

    /**
     * 发货方联系人
     */
    @ApiModelProperty(name = "发货方联系人",notes = "发货方联系人")
    @Column(name = "delivery_contacts", length = 64, columnDefinition = "VARCHAR(64) COMMENT '发货方联系人'")
    private String deliveryContacts;

    /**
     * 发货方联系电话
     */
    @ApiModelProperty(name = "发货方联系电话",notes = "发货方联系电话")
    @Column(name = "delivery_phone", length = 32, columnDefinition = "VARCHAR(32) COMMENT '发货方联系电话'")
    private String deliveryPhone;

    /**
     * 客户编码
     */
    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    @Column(name = "customer_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码'")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    @Column(name = "customer_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '客户名称'")
    private String customerName;

    /**
     * 收货地址
     */
    @ApiModelProperty(name = "收货地址", notes = "收货地址")
    @Column(name = "recipient_address", length = 256, columnDefinition = "VARCHAR(256) COMMENT '收货地址'")
    private String recipientAddress;

    /**
     * 收货联系人
     */
    @ApiModelProperty(name = "收货联系人", notes = "收货联系人")
    @Column(name = "recipient_contacts", length = 64, columnDefinition = "VARCHAR(64) COMMENT '收货联系人'")
    private String recipientContacts;

    /**
     * 收货联系电话
     */
    @ApiModelProperty(name = "收货联系电话", notes = "收货联系电话")
    @Column(name = "recipient_phone", length = 32, columnDefinition = "VARCHAR(32) COMMENT '收货联系电话'")
    private String recipientPhone;

    /**
     * 发货时间
     */
    @ApiModelProperty(name = "发货时间", notes = "发货时间")
    @Column(name = "delivery_date", columnDefinition = "VARCHAR(32) COMMENT '发货时间'")
    private String deliveryDate;

    /**
     * 收货时间
     */
    @ApiModelProperty(name = "收货时间", notes = "收货时间")
    @Column(name = "recipient_date", columnDefinition = "VARCHAR(32) COMMENT '收货时间'")
    private String recipientDate;

    /**
     * 发货数量
     */
    @ApiModelProperty(name = "发货数量", notes = "发货数量")
    @Column(name = "delivery_quantity", nullable = true, columnDefinition = "decimal(20,4) COMMENT '发货数量'")
    private BigDecimal deliveryQuantity;

    /**
     * 已发货数量
     */
    @ApiModelProperty(name = "已发货数量", notes = "已发货数量")
    @Column(name = "already_delivery_quantity", nullable = true, columnDefinition = "decimal(20,4) COMMENT '已发货数量'")
    private BigDecimal alreadyDeliveryQuantity;

    /**
     * 发货金额（发货数量*金额）
     */
    @ApiModelProperty(name = "发货金额", notes = "发货金额")
    @Column(name = "delivery_amount", nullable = true, columnDefinition = "decimal(20,6) COMMENT '发货金额'")
    private BigDecimal deliveryAmount;

    /**
     * 签收数量
     */
    @ApiModelProperty(name = "签收数量", notes = "签收数量")
    @Column(name = "receiving_quantity", nullable = true, columnDefinition = "decimal(20,4) COMMENT '签收数量'")
    private BigDecimal receivingQuantity;

    /**
     * 签收金额
     */
    @ApiModelProperty(name = "签收金额", notes = "签收金额")
    @Column(name = "receiving_amount", nullable = true, columnDefinition = "decimal(20,6) COMMENT '签收金额'")
    private BigDecimal receivingAmount;

    /**
     * 合同id
     */
    @ApiModelProperty(name = "合同id", notes = "合同id")
    @Column(name = "contract_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '合同id'")
    private String contractId;

    /**
     * 文档id
     */
    @ApiModelProperty(name = "文档id", notes = "文档id")
    @Column(name = "documents_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '文档id'")
    private String documentsId;

    /**
     * 签收时间
     */
    @ApiModelProperty(name = "签收时间", notes = "签收时间")
    @Column(name = "receiving_date", columnDefinition = "VARCHAR(32) COMMENT '签收时间'")
    private String receivingDate;

}
