package com.biz.crm.tpm.business.material.purchasing.order.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 物料采购单-文件表 实体
 *
 * @author duyiran
 * @create 2022-11-12 15:52
 */
@Data
@TableName("tpm_material_purchasing_order_file")
@Entity(name = "tpm_material_purchasing_order_file")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmMaterialPurchasingOrderFile", description = "TPM-物料采购单-文件表")
@org.hibernate.annotations.Table(appliesTo = "tpm_material_purchasing_order_file", comment = "TPM-物料采购单-文件表")
@Table(name = "tpm_material_purchasing_order_file")
public class TpmMaterialPurchasingOrderFile extends FileEntity {

    /**
     * 业务编码
     */
    @ApiModelProperty(name = "业务编码", notes = "业务编码")
    @Column(name = "business_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '采购单详情编码'")
    private String businessCode;

    /**
     * 文件类型
     */
    @ApiModelProperty(name = "fileType",value = "文件类型",notes = "文件类型")
    @Column(name = "file_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '文件类型 '")
    private String fileType;

}
