package com.biz.crm.tpm.business.material.purchasing.order.local.export;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.material.purchasing.order.local.service.TpmMaterialPurchasingOrderAuditInvoiceService;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderAuditInvoiceExportVo;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * 发票导出
 * @author hd
 */
@Component
public class TpmMaterialPurchasingOrderAuditInvoiceExportsProcess implements ExportProcess<TpmMaterialPurchasingOrderAuditInvoiceExportVo> {
    @Autowired(required = false)
    private TpmMaterialPurchasingOrderAuditInvoiceService tpmMaterialPurchasingOrderAuditInvoiceService;

    @Override
    public Integer getPageSize(){
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    @Override
    public Integer getTotal(Map<String, Object> params) {
        String cacheKey = getCacheKey(params);
        Integer total = this.tpmMaterialPurchasingOrderAuditInvoiceService.getTotal(cacheKey);
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }
    private String getCacheKey(Map<String, Object> params) {
        Object cacheKey = params.get("cacheKey");
        Validate.notNull(cacheKey,"缓存Key不能为空");
        return (String) cacheKey;
    }
    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        String cacheKey = getCacheKey(params);
        List<TpmMaterialPurchasingOrderAuditInvoiceExportVo> result = this.tpmMaterialPurchasingOrderAuditInvoiceService.getInvoiceExportData(cacheKey);
        this.transfer(result);
        return toJSONArray(result);
    }

    private void transfer(List<TpmMaterialPurchasingOrderAuditInvoiceExportVo> result) {

    }

    @Override
    public Class<TpmMaterialPurchasingOrderAuditInvoiceExportVo> findCrmExcelVoClass() {
        return TpmMaterialPurchasingOrderAuditInvoiceExportVo.class;
    }
    @Override
    public String getBusinessCode() {
        return "TPM_MATERIAL_PURCHASING_ORDER_AUDIT_INVOICE_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "采购单发票明细导出";
    }

}
