package com.biz.crm.tpm.business.material.purchasing.order.local.export;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.material.purchasing.order.local.service.TpmMaterialPurchasingOrderDetailService;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDetailDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderDetailVo;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderMaterialGroupExportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @author: chenlong
 * @date: 2023/2/7 16:49
 * @description: 活动细案明细物料组导出
 */
@Slf4j
@Component
public class TpmMaterialPurchasingOrderMaterialGroupExportsProcess implements ExportProcess<TpmMaterialPurchasingOrderMaterialGroupExportsVo> {

    @Autowired(required = false)
    private TpmMaterialPurchasingOrderDetailService detailService;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Override
    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }


    @Override
    public Integer getTotal(Map<String, Object> params) {
        String cacheKey = getCacheKey(params);
        Integer total = detailService.getTotal(cacheKey);
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    private String getCacheKey(Map<String, Object> params) {
        Object cacheKey = params.get("cacheKey");
        Validate.notNull(cacheKey, "缓存Key不能为空");
        return (String) cacheKey;
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        String cacheKey = getCacheKey(params);
        Pageable pageable = PageRequest.of(vo.getPageNo() + 1, this.getPageSize());
        Page<TpmMaterialPurchasingOrderDetailVo> detailVoList = detailService.findCachePageList(pageable, new TpmMaterialPurchasingOrderDetailDto(), cacheKey);
        if (CollectionUtils.isEmpty(detailVoList.getRecords())) {
            return new JSONArray();
        }
        Collection<TpmMaterialPurchasingOrderMaterialGroupExportsVo> exportsVos = nebulaToolkitService.copyCollectionByWhiteList(
                detailVoList.getRecords(), TpmMaterialPurchasingOrderDetailVo.class, TpmMaterialPurchasingOrderMaterialGroupExportsVo.class, LinkedHashSet.class, ArrayList.class);
        //调整
        adjustData(exportsVos);
        return JSON.parseArray(JSON.toJSONString(exportsVos));
    }

    @Override
    public String getBusinessCode() {
        return "TPM_MATERIAL_PURCHASING_ORDER_MATERIAL_GROOUP_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "物料采购单物料组编辑导出";
    }

    /**
     * 调整数据
     * @param data
     */
    private void adjustData(Collection<TpmMaterialPurchasingOrderMaterialGroupExportsVo> data) {
        for (TpmMaterialPurchasingOrderMaterialGroupExportsVo vo : data) {
            if (Objects.nonNull(vo.getDeliveryDate())) {
                //vo.setDeliveryDateStr(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd_HH_mm_ss, vo.getDeliveryDate()));
                vo.setDeliveryDateStr(vo.getDeliveryDate());
            }
            if (Objects.nonNull(vo.getRecipientDate())) {
                //vo.setRecipientDateStr(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd_HH_mm_ss, vo.getRecipientDate()));
                vo.setRecipientDateStr(vo.getRecipientDate());
            }
            if (Objects.nonNull(vo.getCreateTime())) {
                vo.setCreateTimeStr(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd_HH_mm_ss, vo.getCreateTime()));
            }
            if (Objects.nonNull(vo.getModifyTime())) {
                vo.setModifyTimeStr(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd_HH_mm_ss, vo.getModifyTime()));
            }
        }
    }

    /**
     * 获取对象转换实体
     * @return
     */
    @Override
    public Class<TpmMaterialPurchasingOrderMaterialGroupExportsVo> findCrmExcelVoClass() {
        return TpmMaterialPurchasingOrderMaterialGroupExportsVo.class;
    }
}
