package com.biz.crm.tpm.business.material.purchasing.order.local.helper;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderAuditInvoice;
import com.biz.crm.tpm.business.material.purchasing.order.local.repository.TpmMaterialPurchasingOrderAuditInvoiceRepository;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.constant.TpmMaterialPurchasingOrderConstant;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderAuditInvoiceDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderAuditInvoiceVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

@Component
public class TpmMaterialPurchasingOrderAuditInvoiceCacheHelper
        extends MnPageCacheHelper<TpmMaterialPurchasingOrderAuditInvoiceVo, TpmMaterialPurchasingOrderAuditInvoiceDto> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private TpmMaterialPurchasingOrderAuditInvoiceRepository tpmMaterialPurchasingOrderAuditInvoiceRepository;

    /**
     * 缓存键前缀
     */
    @Override
    public String getCacheKeyPrefix() {
        return TpmMaterialPurchasingOrderConstant.TPM_MATERIAL_PURCHASING_ORDER_AUDIT_INVOICE_CACHE;
    }

    /**
     * @return Dto Class对象
     */
    @Override
    public Class<TpmMaterialPurchasingOrderAuditInvoiceDto> getDtoClass() {
        return TpmMaterialPurchasingOrderAuditInvoiceDto.class;
    }

    /**
     * @return Vo Class对象
     */
    @Override
    public Class<TpmMaterialPurchasingOrderAuditInvoiceVo> getVoClass() {
        return TpmMaterialPurchasingOrderAuditInvoiceVo.class;
    }

    /**
     * 从数据库查询初始化数据
     * @param dto
     * @param cacheKey
     */
    @Override
    public List<TpmMaterialPurchasingOrderAuditInvoiceDto> findDtoListFromRepository(TpmMaterialPurchasingOrderAuditInvoiceDto dto, String cacheKey) {
        if (StringUtils.isEmpty(dto.getCode())) {
            return Lists.newArrayList();
        }

        //从数据库里面查出来放到缓存里面
        List<TpmMaterialPurchasingOrderAuditInvoice> dtoList = this.tpmMaterialPurchasingOrderAuditInvoiceRepository.findByCode(dto.getCode());
        if (CollectionUtils.isEmpty(dtoList)) return Lists.newArrayListWithCapacity(0);
        return (List<TpmMaterialPurchasingOrderAuditInvoiceDto>)
                this.nebulaToolkitService.copyCollectionByWhiteList(dtoList,
                                                                    TpmMaterialPurchasingOrderAuditInvoice.class,
                                                                    TpmMaterialPurchasingOrderAuditInvoiceDto.class,
                                                                    HashSet.class, ArrayList.class);
    }

    /**
     * 新增数据
     * @param cacheKey
     * @param itemList
     */
    @Override
    public List<TpmMaterialPurchasingOrderAuditInvoiceDto> newItem(String cacheKey, List<TpmMaterialPurchasingOrderAuditInvoiceDto> itemList) {
        itemList.forEach(e -> {
            e.setId(UUID.randomUUID().toString().replace("-", ""));
            e.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        });

        return itemList;
    }

    /**
     * 复制数据
     * @param cacheKey
     * @param itemList
     */
    @Override
    public List<TpmMaterialPurchasingOrderAuditInvoiceDto> copyItem(String cacheKey, List<TpmMaterialPurchasingOrderAuditInvoiceDto> itemList) {
        List<TpmMaterialPurchasingOrderAuditInvoiceDto> newItemList = (List<TpmMaterialPurchasingOrderAuditInvoiceDto>) this.nebulaToolkitService.copyCollectionByBlankList(itemList, TpmMaterialPurchasingOrderAuditInvoiceDto.class, TpmMaterialPurchasingOrderAuditInvoiceDto.class, HashSet.class, ArrayList.class);
        for (TpmMaterialPurchasingOrderAuditInvoiceDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        return newItemList;
    }

    /**
     * 获取Dto中的主键
     * @param dto
     * @return 主键
     */
    @Override
    public Object getDtoKey(TpmMaterialPurchasingOrderAuditInvoiceDto dto) {
        return dto.getId();
    }

    /**
     * 获取是否选中状态
     * @param dto
     * @return 主键
     */
    @Override
    public String getCheckedStatus(TpmMaterialPurchasingOrderAuditInvoiceDto dto) {
        return dto.getChecked();
    }

    @Override
    public void filterSaveItem(String cacheKey, List<Object> idList, List<TpmMaterialPurchasingOrderAuditInvoiceDto> itemList, List<TpmMaterialPurchasingOrderAuditInvoiceDto> updateList){
        itemList.removeIf(item -> idList.contains(this.getDtoKey(item)));
    }
}
