package com.biz.crm.tpm.business.material.purchasing.order.local.helper;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.material.purchasing.order.local.repository.TpmMaterialPurchasingOrderDetailRepository;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.constant.TpmMaterialPurchasingOrderConstant;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDetailDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

@Component
public class TpmMaterialPurchasingOrderDetailCacheHelper
        extends MnPageCacheHelper<TpmMaterialPurchasingOrderDetailVo, TpmMaterialPurchasingOrderDetailDto> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private TpmMaterialPurchasingOrderDetailRepository tpmMaterialPurchasingOrderDetailRepository;

    /**
     * 缓存键前缀
     */
    @Override
    public String getCacheKeyPrefix() {
        return TpmMaterialPurchasingOrderConstant.TPM_MATERIAL_PURCHASING_ORDER_AUDIT_INVOICE_CACHE;
    }

    /**
     * @return Dto Class对象
     */
    @Override
    public Class<TpmMaterialPurchasingOrderDetailDto> getDtoClass() {
        return TpmMaterialPurchasingOrderDetailDto.class;
    }

    /**
     * @return Vo Class对象
     */
    @Override
    public Class<TpmMaterialPurchasingOrderDetailVo> getVoClass() {
        return TpmMaterialPurchasingOrderDetailVo.class;
    }

    /**
     * 从数据库查询初始化数据
     * @param dto
     * @param cacheKey
     */
    @Override
    public List<TpmMaterialPurchasingOrderDetailDto> findDtoListFromRepository(TpmMaterialPurchasingOrderDetailDto dto, String cacheKey) {
        if (StringUtils.isEmpty(dto.getCode())) {
            return Lists.newArrayList();
        }

        //从数据库里面查出来放到缓存里面
        List<TpmMaterialPurchasingOrderDetailVo> dtoList = this.tpmMaterialPurchasingOrderDetailRepository.findByCode(dto.getCode());
        if(StringUtils.isNotEmpty(dto.getProcessNo())){
            dtoList = dtoList.stream().filter(o -> dto.getProcessNo().equals(o.getProcessNo())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(dtoList)) return Lists.newArrayListWithCapacity(0);
        return (List<TpmMaterialPurchasingOrderDetailDto>)
                this.nebulaToolkitService.copyCollectionByWhiteList(dtoList,
                                                                    TpmMaterialPurchasingOrderDetailVo.class,
                                                                    TpmMaterialPurchasingOrderDetailDto.class,
                                                                    HashSet.class, ArrayList.class);
    }

    /**
     * 新增数据
     * @param cacheKey
     * @param itemList
     */
    @Override
    public List<TpmMaterialPurchasingOrderDetailDto> newItem(String cacheKey, List<TpmMaterialPurchasingOrderDetailDto> itemList) {
        itemList.forEach(e -> {
            e.setId(UUID.randomUUID().toString().replace("-", ""));
            e.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        });

        return itemList;
    }

    /**
     * 复制数据
     * @param cacheKey
     * @param itemList
     */
    @Override
    public List<TpmMaterialPurchasingOrderDetailDto> copyItem(String cacheKey, List<TpmMaterialPurchasingOrderDetailDto> itemList) {
        List<TpmMaterialPurchasingOrderDetailDto> newItemList = (List<TpmMaterialPurchasingOrderDetailDto>) this.nebulaToolkitService.copyCollectionByBlankList(itemList, TpmMaterialPurchasingOrderDetailDto.class, TpmMaterialPurchasingOrderDetailDto.class, HashSet.class, ArrayList.class);
        for (TpmMaterialPurchasingOrderDetailDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        return newItemList;
    }

    /**
     * 获取Dto中的主键
     * @param dto
     * @return 主键
     */
    @Override
    public Object getDtoKey(TpmMaterialPurchasingOrderDetailDto dto) {
        return dto.getId();
    }

    /**
     * 获取是否选中状态
     * @param dto
     * @return 主键
     */
    @Override
    public String getCheckedStatus(TpmMaterialPurchasingOrderDetailDto dto) {
        return dto.getChecked();
    }

    @Override
    public void filterSaveItem(String cacheKey, List<Object> idList, List<TpmMaterialPurchasingOrderDetailDto> itemList, List<TpmMaterialPurchasingOrderDetailDto> updateList) {
        itemList.removeIf(item -> idList.contains(this.getDtoKey(item)));
    }
}
