package com.biz.crm.tpm.business.material.purchasing.order.local.imports;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.material.purchasing.order.local.service.TpmMaterialPurchasingOrderDetailService;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDetailDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderMaterialGroupImportVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 物料采购单物料组编辑导入
 * @author zhouyang
 * @date 2023/09/22
 */
@Slf4j
@Component
public class TpmMaterialPurchasingOrderMaterialGroupImportsProcess implements ImportProcess<TpmMaterialPurchasingOrderMaterialGroupImportVo> {

    @Autowired
    private TpmMaterialPurchasingOrderDetailService detailService;


    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, TpmMaterialPurchasingOrderMaterialGroupImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Object cacheKey = params.get("cacheKey");
        Validate.notNull(cacheKey, "缓存cacheKey不能为空");

        if (CollectionUtil.isNotEmpty(data)) {
            Collection<TpmMaterialPurchasingOrderMaterialGroupImportVo> importVos = data.values();
            if (CollectionUtil.isNotEmpty(importVos)) {
                List<TpmMaterialPurchasingOrderMaterialGroupImportVo> importVoList = Lists.newArrayList(importVos);
                for (int i = 0; i < importVoList.size(); i++) {
                    TpmMaterialPurchasingOrderMaterialGroupImportVo importVo = importVoList.get(i);
                    Integer index = i + 1;
                    Validate.notEmpty(importVo.getId(), "第" + index + "行,主键不能为空");
                }
                List<TpmMaterialPurchasingOrderDetailDto> detailVoList = this.detailService.findCacheList((String) cacheKey);
                Map<String, TpmMaterialPurchasingOrderMaterialGroupImportVo> importVoMap = importVos.stream().collect(Collectors.toMap(TpmMaterialPurchasingOrderMaterialGroupImportVo::getId, Function.identity()));
                detailVoList.forEach(detailVo -> {
                    if (importVoMap.containsKey(detailVo.getId())) {
                        TpmMaterialPurchasingOrderMaterialGroupImportVo importVo = importVoMap.get(detailVo.getId());
                        detailVo.setRecipientAddress(importVo.getRecipientAddress());
                        detailVo.setRecipientPhone(importVo.getRecipientPhone());
                        detailVo.setRecipientContacts(importVo.getRecipientContacts());
                    }
                });
                this.detailService.addItemCache((String) cacheKey, detailVoList);
            }
        }
        return null;
    }

    @Override
    public Class<TpmMaterialPurchasingOrderMaterialGroupImportVo> findCrmExcelVoClass() {
        return TpmMaterialPurchasingOrderMaterialGroupImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_MATERIAL_PURCHASING_ORDER_MATERIAL_GROUP_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "TPM-物料采购单明细导入-物料组";
    }

    @Override
    public String getBusinessCode() {
        return "TPM_MATERIAL_PURCHASING_ORDER_MATERIAL_GROUP_IMPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM-物料采购单明细物料组导入";
    }

}
