package com.biz.crm.tpm.business.material.purchasing.order.local.listener;

import com.alibaba.fastjson.JSON;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.MaterialPurchasingCloseEventDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.MaterialPurchasingEventDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.event.materialPurchaingOrder.MaterialPurchasingOrderEventListener;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrder;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderDetail;
import com.biz.crm.tpm.business.material.purchasing.order.local.repository.TpmMaterialPurchasingOrderDetailRepository;
import com.biz.crm.tpm.business.material.purchasing.order.local.repository.TpmMaterialPurchasingOrderRepository;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.enums.TpmMaterialPurchasingOrderEnums;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.service.TpmMaterialPurchasingOrderService;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author: zhouyang
 * @Date: 2023/9/15
 */
@Slf4j
@Component
public class MaterialPurchasingOrderEventListenerImpl implements MaterialPurchasingOrderEventListener {

    @Autowired
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired
    private TpmMaterialPurchasingOrderRepository tpmMaterialPurchasingOrderRepository;
    @Autowired
    private TpmMaterialPurchasingOrderDetailRepository tpmMaterialPurchasingOrderDetailRepository;
    @Autowired
    private TpmMaterialPurchasingOrderService tpmMaterialPurchasingOrderService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void onActivityDetailPlanModify(MaterialPurchasingEventDto dto) {
        log.info("细案明细进行调整修改物料采购单调整状态修改,{}", JSON.toJSONString(dto));
        if (Objects.isNull(dto) || StringUtils.isEmpty(dto.getActivityDetailPlanCode()) || StringUtils.isEmpty(dto.getProcessStatus())) {
            return;
        }
        String detailPlanCode = dto.getActivityDetailPlanCode();
        String modifyBusinessCode = dto.getModifyBusinessCode();
        List<ActivityDetailPlanItemVo> originalVoList = activityDetailPlanItemSdkService.findListByDetailPlanCode(detailPlanCode);
        log.info("细案明细进行调整修改物料采购单调整状态修改,originalVoList:{}", JSON.toJSONString(originalVoList));
        List<ActivityDetailPlanItemModifyDto> modifyDtoList = this.activityDetailPlanItemSdkService.findDtoListByModifyCode(modifyBusinessCode);
        log.info("细案明细进行调整修改物料采购单调整状态修改,modifyDtoList:{}", JSON.toJSONString(modifyDtoList));
        Map<String, ActivityDetailPlanItemModifyDto> modifyDtoMap = modifyDtoList.stream().collect(Collectors.toMap(ActivityDetailPlanItemModifyDto::getDetailPlanItemCode, Function.identity()));

        Map<String, BigDecimal> activityDetailPlanItemMap = new HashMap<>();
        for (ActivityDetailPlanItemVo itemVo : originalVoList) {
            ActivityDetailPlanItemModifyDto modifyDto = modifyDtoMap.get(itemVo.getDetailPlanItemCode());
            if(modifyDto!=null) {
                if(Optional.ofNullable(itemVo.getMaterialQuantity()).orElse(BigDecimal.ZERO).compareTo(Optional.ofNullable(modifyDto.getMaterialQuantity()).orElse(BigDecimal.ZERO))!=0){
                    activityDetailPlanItemMap.put(itemVo.getDetailPlanItemCode(),modifyDto.getMaterialQuantity());
                }
            }
        }
        Set<String> detailPlanItemCodes = activityDetailPlanItemMap.keySet();
        log.info("细案明细进行调整修改物料采购单调整状态修改,key:{},value:{}", JSON.toJSONString(activityDetailPlanItemMap.keySet()),JSON.toJSONString(activityDetailPlanItemMap.values()));
        if (CollectionUtils.isNotEmpty(detailPlanItemCodes)) {
            List<TpmMaterialPurchasingOrderDetail> detailList = tpmMaterialPurchasingOrderDetailRepository.findByActivityDetailItemCodes(new ArrayList<>(detailPlanItemCodes));
            log.info("细案明细进行调整修改物料采购单调整状态修改-采购单明细数据,{}", JSON.toJSONString(detailList));
            if (CollectionUtils.isNotEmpty(detailList)) {

                List<String> purchasingOrderCodes = detailList.stream().map(TpmMaterialPurchasingOrderDetail::getCode).collect(Collectors.toList());
                List<TpmMaterialPurchasingOrder> purchasingOrderList = tpmMaterialPurchasingOrderRepository.findByCodeList(purchasingOrderCodes);
                log.info("细案明细进行调整修改物料采购单调整状态修改-采购单抬头数据,{}", JSON.toJSONString(purchasingOrderList));
                detailList = filterProcessStatus(purchasingOrderList, detailList);
                log.info("细案明细进行调整修改物料采购单调整状态修改-采购单明细过滤后的数据,{}", JSON.toJSONString(detailList));
                if (CollectionUtils.isNotEmpty(detailList)) {
//                    List<TpmMaterialPurchasingOrderDetail> newDetailList = detailList.stream()
//                            .filter(a -> StringUtils.equals(a.getReceivingStatus(), TpmMaterialPurchasingOrderEnums.ReceiveStatus.WAIT_RECEIVE.getValue())
//                                    || StringUtils.equals(a.getReceivingStatus(), TpmMaterialPurchasingOrderEnums.ReceiveStatus.PORTIAL_RECEIVE.getValue())
//                                    || StringUtils.equals(a.getReceivingStatus(), TpmMaterialPurchasingOrderEnums.ReceiveStatus.PORTIAL_DELIVERIED.getValue()))
//                            .collect(Collectors.toList());
//                    log.info("细案明细进行调整修改物料采购单调整状态修改-过滤后的数据,{}", JSON.toJSONString(newDetailList));
                    StringBuffer changeStatus = new StringBuffer();
                    if (dto.getProcessStatus().equals(ProcessStatusEnum.COMMIT.getKey())) {
                        changeStatus.append(TpmMaterialPurchasingOrderEnums.OrderChangeStatus.CHANGEING.getValue());
                    } else if (dto.getProcessStatus().equals(ProcessStatusEnum.PASS.getKey())) {
                        changeStatus.append(TpmMaterialPurchasingOrderEnums.OrderChangeStatus.CHANGED.getValue());
                    } else {
                        changeStatus.append(TpmMaterialPurchasingOrderEnums.OrderChangeStatus.NOT_CHANGED.getValue());
                    }
                    detailList.forEach(detail -> {
                        detail.setActivityDetailChangeStatus(changeStatus.toString());
                        if (dto.getProcessStatus().equals(ProcessStatusEnum.PASS.getKey())) {
                            //审批通过之后修改采购数量
                            detail.setPurchasingQuantity(activityDetailPlanItemMap.get(detail.getActivityDetailItemCode()));
                        }
                    });
                    log.info("细案明细进行调整修改物料采购单调整状态修改-采购单明细要修改的数据,{}", JSON.toJSONString(detailList));
                    this.tpmMaterialPurchasingOrderDetailRepository.updateBatchById(detailList);
                    //针对本次修改的明细对应的采购单做一个状态计算
                    List<String> materialPurchasingCodes = detailList.stream().map(TpmMaterialPurchasingOrderDetail::getCode).distinct().collect(Collectors.toList());
                    this.tpmMaterialPurchasingOrderService.handleChangeStatus(materialPurchasingCodes);
                }
            }
        }
    }

    private List<TpmMaterialPurchasingOrderDetail> filterProcessStatus(List<TpmMaterialPurchasingOrder> purchasingOrderList, List<TpmMaterialPurchasingOrderDetail> detailList) {
        if(CollectionUtils.isEmpty(detailList)){
            return Lists.newArrayList();
        }
        if(CollectionUtils.isEmpty(purchasingOrderList)){
            return Lists.newArrayList();
        }
        List<String> purchasingOrderCodeList = purchasingOrderList.stream().filter(o -> TpmMaterialPurchasingOrderEnums.OrderStatus.TO_SUBMIT_10.getValue().equals(o.getStatus())
                || TpmMaterialPurchasingOrderEnums.OrderStatus.BACK_40.getValue().equals(o.getStatus())).map(TpmMaterialPurchasingOrder::getCode).collect(Collectors.toList());
        return detailList.stream().filter(item->purchasingOrderCodeList.contains(item.getCode())).collect(Collectors.toList());
    }

    /**
     * 明细关闭
     * @param dto
     */
    @Override
    public void onActivityDetailPlanItemClose(MaterialPurchasingCloseEventDto dto) {
        if (Objects.isNull(dto) || CollectionUtils.isEmpty(dto.getActivityDetailPlanItemCodes())) {
            return;
        }
        List<TpmMaterialPurchasingOrderDetail> detailList = tpmMaterialPurchasingOrderDetailRepository.findByActivityDetailItemCodes(dto.getActivityDetailPlanItemCodes());
        if (CollectionUtils.isNotEmpty(detailList)) {
            List<TpmMaterialPurchasingOrderDetail> newDetailList = detailList.stream()
                    .filter(a -> StringUtils.equals(a.getReceivingStatus(), TpmMaterialPurchasingOrderEnums.ReceiveStatus.WAIT_RECEIVE.getValue()))
                    .filter(a -> StringUtils.equals(a.getReceivingStatus(), TpmMaterialPurchasingOrderEnums.ReceiveStatus.PORTIAL_RECEIVE.getValue()))
                    .filter(a -> StringUtils.equals(a.getReceivingStatus(), TpmMaterialPurchasingOrderEnums.ReceiveStatus.PORTIAL_DELIVERIED.getValue()))
                    .collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(newDetailList)) {
                // 找到主表信息
                List<String> materialPurchasingCodes = newDetailList.stream().map(TpmMaterialPurchasingOrderDetail::getCode).distinct().collect(Collectors.toList());
                List<TpmMaterialPurchasingOrder> entityList = tpmMaterialPurchasingOrderRepository.findByCodeList(materialPurchasingCodes);
                if (CollectionUtils.isNotEmpty(entityList)) {
                    entityList.forEach(entity -> {
                        entity.setChangeStatus(TpmMaterialPurchasingOrderEnums.OrderChangeStatus.CHANGED.getValue());
                    });
                }
                // 删除
                List<String> ids = newDetailList.stream().map(TpmMaterialPurchasingOrderDetail::getId).distinct().collect(Collectors.toList());
                this.tpmMaterialPurchasingOrderRepository.updateBatchById(entityList);
                this.tpmMaterialPurchasingOrderDetailRepository.removeByIds(ids);
            }
        }
    }
}
