package com.biz.crm.tpm.business.material.purchasing.order.local.listener;

import com.biz.crm.tpm.business.material.purchasing.order.local.service.TpmMaterialPurchasingOrderDetailService;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.constant.TpmMaterialPurchasingOrderConstant;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.enums.TpmMaterialPurchasingOrderEnums;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.service.TpmMaterialPurchasingOrderService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 物料采购单审批通过回调(确认)
 * @author zy
 * @date 2023/09/14
 */
@Component
public class TpmMaterialPurchasingProcessCompleteListener implements ProcessCompleteListener {

    @Autowired
    private TpmMaterialPurchasingOrderService tpmMaterialPurchasingOrderService;
    @Autowired
    private TpmMaterialPurchasingOrderDetailService tpmMaterialPurchasingOrderDetailService;

    @Override
    public String getBusinessCode() {
        return TpmMaterialPurchasingOrderConstant.TPM_MATERIAL_PURCHASING_ORDER_PROCESS;
    }

    @Override
    @Transactional
    public void onProcessComplete(ProcessStatusDto dto) {
        if (CollectionUtils.isEmpty(dto.getBusinessNoList())) {
            return;
        }
        //提交
        String processStatus = dto.getProcessStatus();
        Validate.notEmpty(dto.getProcessNo(), "流程编码不能为空！");
        //审批通过
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            this.tpmMaterialPurchasingOrderService.processBack(dto.getBusinessNoList(), TpmMaterialPurchasingOrderEnums.OrderStatus.CONFIRM_30.getValue());
            //如果是通过初始化明细的签收状态
            this.tpmMaterialPurchasingOrderDetailService.updateReceivingStatusByCodes(dto.getBusinessNoList(), TpmMaterialPurchasingOrderEnums.ReceiveStatus.WAIT_RECEIVE.getValue());
            //生成 - pdf签收单
            this.tpmMaterialPurchasingOrderDetailService.generateSignInPdfByCodes(dto.getBusinessNoList());
        }
        //审批驳回
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus)) {
            this.tpmMaterialPurchasingOrderService.processBack(dto.getBusinessNoList(), TpmMaterialPurchasingOrderEnums.OrderStatus.WAIT_EDIT.getValue());
        }
        //流程追回
        if (ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            this.tpmMaterialPurchasingOrderService.processBack(dto.getBusinessNoList(), TpmMaterialPurchasingOrderEnums.OrderStatus.BACK_40.getValue());
        }
    }
}
