package com.biz.crm.tpm.business.material.purchasing.order.local.listener;

import com.biz.crm.tpm.business.material.purchasing.order.local.service.TpmMaterialPurchasingOrderDetailService;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.constant.TpmMaterialPurchasingOrderConstant;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.service.TpmMaterialPurchasingOrderService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.common.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 物料采购单审批通过回调（提交审批）
 * @author zy
 * @date 2023/09/14
 */
@Component
@Slf4j
public class TpmMaterialPurchasingSupplierProcessCompleteListener implements ProcessCompleteListener {

    @Autowired
    private TpmMaterialPurchasingOrderService tpmMaterialPurchasingOrderService;
    @Autowired
    private TpmMaterialPurchasingOrderDetailService tpmMaterialPurchasingOrderDetailService;

    @Override
    public String getBusinessCode() {
        return TpmMaterialPurchasingOrderConstant.TPM_MATERIAL_PURCHASING_ORDER_SUPPLIER_PROCESS;
    }

    @Override
    @Transactional
    public void onProcessComplete(ProcessStatusDto dto) {

        log.info("物料采购单提交审批审批通过 dto:{}", JsonUtils.obj2JsonString(dto));
        if (CollectionUtils.isEmpty(dto.getBusinessNoList())) {
            return;
        }
        String processStatus = dto.getProcessStatus();
        Validate.notEmpty(dto.getProcessNo(), "流程编码不能为空！");
        tpmMaterialPurchasingOrderService.supplierProcessBack(dto.getBusinessNoList(), processStatus);
    }
}
