package com.biz.crm.tpm.business.material.purchasing.order.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderDetail;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDetailDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderfindCustomerDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderDetailVo;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderFindCustomerVo;
import org.apache.ibatis.annotations.Param;

/**
 * TPM-物料采购单-明细表(TpmMaterialPurchasingOrderDetail)表mybatis访问层
 *
 * @author duyiran
 * @since 2022-11-12 17:56:44
 */
public interface TpmMaterialPurchasingOrderDetailMapper extends BaseMapper<TpmMaterialPurchasingOrderDetail> {

    /**
     * 分页查询该采购单所有客户
     *
     * @param page 分页对象
     * @param dto  dto
     * @return 所有数据
     */
    Page<TpmMaterialPurchasingOrderFindCustomerVo> findCustomerByCode(@Param("page") Page<TpmMaterialPurchasingOrderFindCustomerVo> page, @Param("dto") TpmMaterialPurchasingOrderfindCustomerDto dto);

    /**
     * 分页查询当前采购单所有可发货明细
     *
     * @param page 分页对象
     * @param dto  查询dto
     * @return 所有数据
     */
    Page<TpmMaterialPurchasingOrderDetailVo> findOutStorageAbleDetailById(@Param("page") Page<TpmMaterialPurchasingOrderDetailVo> page, @Param("dto") TpmMaterialPurchasingOrderDto dto);

    /**
     * 分页查询所有明细（核销用）
     *
     * @param page 分页对象
     * @param dto  查询dto
     * @return 所有数据
     */
    Page<TpmMaterialPurchasingOrderDetailVo> findDetailListByCodeForAuditPage(@Param("page") Page<TpmMaterialPurchasingOrderDetailVo> page, @Param("dto") TpmMaterialPurchasingOrderDto dto);

    /**
     * 分页查询可以提交审批的明细数据
     * @param page
     * @param dto
     * @return
     */
    Page<TpmMaterialPurchasingOrderDetailVo> findSupplierApprovalList(Page<TpmMaterialPurchasingOrderDetailVo> page,@Param("dto") TpmMaterialPurchasingOrderDto dto);

    Page<TpmMaterialPurchasingOrderDetailVo> auditFindMaterialPurchasingOrderDetailByCondition(@Param("page") Page<TpmMaterialPurchasingOrderDetailVo> page,@Param("dto") TpmMaterialPurchasingOrderDetailDto dto);

    Page<TpmMaterialPurchasingOrderDetailVo> findSupplierSubmitApprovalDetailInfo(@Param("page") Page<TpmMaterialPurchasingOrderDetailVo> page,@Param("dto") TpmMaterialPurchasingOrderDetailDto dto);
}

