package com.biz.crm.tpm.business.material.purchasing.order.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrder;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * TPM-物料采购单(TpmMaterialPurchasingOrder)表mybatis访问层
 *
 * @author duyiran
 * @since 2022-11-12 17:55:51
 */
public interface TpmMaterialPurchasingOrderMapper extends BaseMapper<TpmMaterialPurchasingOrder> {

    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param dto  查询dto
     * @return 所有数据
     */
    Page<TpmMaterialPurchasingOrderVo> findByConditions(@Param("page") Page<TpmMaterialPurchasingOrderVo> page, @Param("dto") TpmMaterialPurchasingOrderDto dto);

    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param dto  查询dto
     * @return 所有数据
     */
    Page<TpmMaterialPurchasingOrderVo> findByConditionsForAuditPage(@Param("page") Page<TpmMaterialPurchasingOrderVo> page, @Param("dto") TpmMaterialPurchasingOrderDto dto);

    /**
     * 查询数据（后端用）
     *
     * @param dto dto对象
     * @return
     */
    List<TpmMaterialPurchasingOrderVo> findByConditionsForJava(@Param("dto") TpmMaterialPurchasingOrderDto dto);

    /**
     * 格局维度验重
     * @param dto
     * @return
     */
    List<TpmMaterialPurchasingOrderVo> findRepeatByDimension(@Param("dto") TpmMaterialPurchasingOrderDto dto);
}

