package com.biz.crm.tpm.business.material.purchasing.order.local.register;

import com.bizunited.nebula.europa.database.local.service.bind.MnCustomParamFieldBindingStrategy;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteParameter;
import com.bizunited.nebula.europa.database.sdk.service.ExecuteParameterBuildInterceptor;
import com.bizunited.nebula.europa.database.sdk.vo.DatabaseViewVo;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Set;

@Component
public class MaterialPurchasingOrderExecuteParameterBuildInterceptor implements ExecuteParameterBuildInterceptor {


    @Autowired(required = false)
    private MnCustomParamFieldBindingStrategy mnCustomParamFieldBindingStrategy;

    /**
     * 流程编码
     */
    public static final String process_no = "process_no";

    @Autowired(required = false)
    private TpmMaterialPurchasingOrderRegister register;

    @Override
    public void onBuildExecuteParameters(MetaData metaData, EuropaInfoVo europaInfoVo, Set<ExecuteParameter> set) {
        DatabaseViewVo view = (DatabaseViewVo)europaInfoVo.getView();
        String dataviewCode = view.getRegisterCode();
        if (!StringUtils.equals(register.code(), dataviewCode)) {
            return;
        }
        for (ExecuteParameter executeParameter : set) {
            if (executeParameter instanceof DatabaseExecuteParameter){
                DatabaseExecuteParameter databaseExecuteParameter = (DatabaseExecuteParameter) executeParameter;
               if (process_no.equals(databaseExecuteParameter.getTargetFieldName())){
                    //流程编码查询
                    databaseExecuteParameter.setValueBindType(MnCustomParamFieldBindingStrategy.PARAM_BIND_TYPE);
                    mnCustomParamFieldBindingStrategy.setEuropaInfoVo(europaInfoVo);
                }
            }
        }
    }

}
