package com.biz.crm.tpm.business.material.purchasing.order.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.bizunited.nebula.europa.database.register.sdk.service.MnDataviewRegister;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteParameter;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterOperatorBindingStrategy;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 数据视图注册器
 * 基于nebula的数据视图提供列表查询功能
 *
 * @author duyiran
 * @create 2022-11-07 20:01
 */
@Component
@Slf4j
public class TpmMaterialPurchasingOrderRegister implements MnDataviewRegister {

    @Autowired(required = false)
    @Qualifier("inParameterOperatorBindingStrategy")
    private ParameterOperatorBindingStrategy inParameterOperatorBindingStrategy;

    @Autowired(required = false)
    private ProcessBusinessMappingService processBusinessMappingService;

    @Override
    public String code() {
        return "tpm_material_purchasing_order_data_view";
    }

    @Override
    public String desc() {
        return "TPM-物料采购单";
    }

    @Override
    public String buildSql() {
        return "select t.* from tpm_material_purchasing_order t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }

    @Override
    public Object customBindingFieldValue(ExecuteParameter executeParameter, DatabaseExecuteExternalRequest databaseExecuteExternalRequest) {
        if (!(executeParameter instanceof DatabaseExecuteParameter)){
            return null;
        }
        DatabaseExecuteParameter databaseExecuteParameter = (DatabaseExecuteParameter) executeParameter;
        String paramName = databaseExecuteParameter.getParamName();
        Object value = databaseExecuteExternalRequest.getAttribute(paramName);
        if (value == null) {
            return null;
        }
        String valueStr = String.valueOf(value);
        if (MaterialPurchasingOrderExecuteParameterBuildInterceptor.process_no.equals(databaseExecuteParameter.getTargetFieldName())){
            return processNoQuery(databaseExecuteParameter,valueStr);
        }
        return valueStr;
    }

    private Object processNoQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr) {
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "code";
        String parameterName = databaseExecuteParameter.getParamName();

        String expression = this.inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);
        List<ProcessBusinessMappingVo> processBusinessMappingVos = this.processBusinessMappingService.findAllByProcessNoCollection(Lists.newArrayList(valueStr));
        if (CollectionUtils.isEmpty(processBusinessMappingVos)){
            return Lists.newArrayList("_");
        }
        return processBusinessMappingVos.stream().map(ProcessBusinessMappingVo::getBusinessNo).collect(Collectors.toList());
    }
}
