package com.biz.crm.tpm.business.material.purchasing.order.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderAuditFile;
import com.biz.crm.tpm.business.material.purchasing.order.local.mapper.TpmMaterialPurchasingOrderAuditFileMapper;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderAuditFileVo;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * TPM-物料采购单-核销文件表(TpmMaterialPurchasingOrderAuditFile)表数据库访问层
 *
 * @author zy
 * @since 2023/09/18
 */
@Component
public class TpmMaterialPurchasingOrderAuditFileRepository extends ServiceImpl<TpmMaterialPurchasingOrderAuditFileMapper, TpmMaterialPurchasingOrderAuditFile> {

    /**
     * 根据业务编码查询文件
     * @param businessCode
     * @return
     */
    public List<TpmMaterialPurchasingOrderAuditFile> findByBusinessCode(String businessCode) {
        if (StringUtils.isEmpty(businessCode)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(TpmMaterialPurchasingOrderAuditFile::getBusinessCode,businessCode)
                .orderByAsc(TpmMaterialPurchasingOrderAuditFile::getTypeCode)
                .list();
    }

    /**
     * 根据业务编码集合查询文件
     * @param businessCodes
     * @return
     */
    public List<TpmMaterialPurchasingOrderAuditFile> findByBusinessCodes(List<String> businessCodes) {
        if (CollectionUtils.isEmpty(businessCodes)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .in(TpmMaterialPurchasingOrderAuditFile::getBusinessCode,businessCodes)
                .list();
    }

    public void deleteByBusinessCode(String businessCode) {
        if (StringUtils.isEmpty(businessCode)) {
            return;
        }
        this.lambdaUpdate()
                .eq(TpmMaterialPurchasingOrderAuditFile::getBusinessCode,businessCode)
                .remove();
    }

    public void deleteByBusinessCodes(List<String> businessCodes) {
        if (CollectionUtils.isEmpty(businessCodes)) {
            return;
        }
        this.lambdaUpdate()
                .in(TpmMaterialPurchasingOrderAuditFile::getBusinessCode,businessCodes)
                .remove();
    }

    public Page<TpmMaterialPurchasingOrderAuditFileVo> auditFindMaterialAuditInfo(Pageable pageable, List<String> materialPurchasingOrders) {
        Page<TpmMaterialPurchasingOrderAuditFileVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        if(CollectionUtils.isEmpty(materialPurchasingOrders)){
            return page;
        }
        return this.getBaseMapper().auditFindMaterialAuditInfo(page,materialPurchasingOrders);
    }
}

