package com.biz.crm.tpm.business.material.purchasing.order.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderAuditInvoice;
import com.biz.crm.tpm.business.material.purchasing.order.local.mapper.TpmMaterialPurchasingOrderAuditInvoiceMapper;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * TPM-物料采购单-核销发票(TpmMaterialPurchasingOrderAuditInvoice)表数据库访问层
 *
 * @author zy
 * @since 2023/09/18
 */
@Component
public class TpmMaterialPurchasingOrderAuditInvoiceRepository extends ServiceImpl<TpmMaterialPurchasingOrderAuditInvoiceMapper, TpmMaterialPurchasingOrderAuditInvoice> {

    /**
     * 根据物料采购单编码删除
     * @param code
     */
    public void deleteByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return;
        }
        this.lambdaUpdate()
                .eq(TpmMaterialPurchasingOrderAuditInvoice::getCode,code)
                .remove();
    }

    /**
     * 根据物料采购单编码查询
     * @param code
     */
    public List<TpmMaterialPurchasingOrderAuditInvoice> findByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(TpmMaterialPurchasingOrderAuditInvoice::getCode,code)
                .list();
    }
}

