package com.biz.crm.tpm.business.material.purchasing.order.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderFile;
import com.biz.crm.tpm.business.material.purchasing.order.local.mapper.TpmMaterialPurchasingOrderFileMapper;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * TPM-物料采购单-明细文件表(TpmMaterialPurchasingOrderDetailFile)表数据库访问层
 *
 * @author zy
 * @since 2023/09/18
 */
@Component
public class TpmMaterialPurchasingOrderFileRepository extends ServiceImpl<TpmMaterialPurchasingOrderFileMapper, TpmMaterialPurchasingOrderFile> {

    /**
     * 根据业务编码查询文件
     * @param businessCode
     * @return
     */
    public List<TpmMaterialPurchasingOrderFile> findByBusinessCode(String businessCode) {
        if (StringUtils.isEmpty(businessCode)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(TpmMaterialPurchasingOrderFile::getBusinessCode,businessCode)
                .list();
    }

    /**
     * 根据业务编码集合查询文件
     * @param businessCodes
     * @return
     */
    public List<TpmMaterialPurchasingOrderFile> findByBusinessCodes(List<String> businessCodes) {
        if (CollectionUtils.isEmpty(businessCodes)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .in(TpmMaterialPurchasingOrderFile::getBusinessCode,businessCodes)
                .list();
    }

    public void deleteByBusinessCode(String businessCode) {
        if (StringUtils.isEmpty(businessCode)) {
            return;
        }
        this.lambdaUpdate()
                .eq(TpmMaterialPurchasingOrderFile::getBusinessCode,businessCode)
                .remove();
    }

    public void deleteByBusinessCodes(List<String> businessCodes) {
        if (CollectionUtils.isEmpty(businessCodes)) {
            return;
        }
        this.lambdaUpdate()
                .in(TpmMaterialPurchasingOrderFile::getBusinessCode,businessCodes)
                .remove();
    }

    /**
     * 根据物料采购单编码查询签收单
     * @param code
     * @return
     */
    public List<TpmMaterialPurchasingOrderFile> findSignByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return Lists.newArrayList();
        }
        return this.baseMapper.findSignByCode(code);
    }
}

