package com.biz.crm.tpm.business.material.purchasing.order.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrder;
import com.biz.crm.tpm.business.material.purchasing.order.local.mapper.TpmMaterialPurchasingOrderMapper;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.*;


/**
 * TPM-物料采购单(TpmMaterialPurchasingOrder)表数据库访问层
 *
 * @author duyiran
 * @since 2022-11-12 17:55:51
 */
@Component
public class TpmMaterialPurchasingOrderRepository extends ServiceImpl<TpmMaterialPurchasingOrderMapper, TpmMaterialPurchasingOrder> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private TpmMaterialPurchasingOrderMapper tpmMaterialPurchasingOrderMapper;

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      dto
     * @return
     */
    public Page<TpmMaterialPurchasingOrderVo> findByConditions(Pageable pageable, TpmMaterialPurchasingOrderDto dto) {
        Page<TpmMaterialPurchasingOrderVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.tpmMaterialPurchasingOrderMapper.findByConditions(page, dto);
    }

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      dto
     * @return
     */
    public Page<TpmMaterialPurchasingOrderVo> findByConditionsForAuditPage(Pageable pageable, TpmMaterialPurchasingOrderDto dto) {
        Page<TpmMaterialPurchasingOrderVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.tpmMaterialPurchasingOrderMapper.findByConditionsForAuditPage(page, dto);
    }


    /**
     * 查询数据（后端用）
     *
     * @param dto dto对象
     * @return
     */
    public List<TpmMaterialPurchasingOrderVo> findByConditionsForJava(TpmMaterialPurchasingOrderDto dto) {
        return this.tpmMaterialPurchasingOrderMapper.findByConditionsForJava(dto);
    }

    /**
     * 根据编码查询数据实体
     *
     * @param code code
     * @return
     */
    public TpmMaterialPurchasingOrder getByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(TpmMaterialPurchasingOrder::getCode, code)
                .eq(TpmMaterialPurchasingOrder::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmMaterialPurchasingOrder::getTenantCode, TenantUtils.getTenantCode())
                .one();
    }

    /**
     * 根据编码集合查询数据实体
     *
     * @param codeList codeList
     * @return
     */
    public List<TpmMaterialPurchasingOrder> findByCodeList(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .in(TpmMaterialPurchasingOrder::getCode, codeList)
                .eq(TpmMaterialPurchasingOrder::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmMaterialPurchasingOrder::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }

    public List<TpmMaterialPurchasingOrderVo> findRepeatByDimension(TpmMaterialPurchasingOrderDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newArrayList();
        }
        return this.tpmMaterialPurchasingOrderMapper.findRepeatByDimension(dto);
    }

    public void updateStatusByCodes(List<String> codes, String status) {
        if (CollectionUtils.isEmpty(codes) || StringUtils.isEmpty(status)) {
            return;
        }
        this.lambdaUpdate()
                .in(TpmMaterialPurchasingOrder::getCode,codes)
                .set(TpmMaterialPurchasingOrder::getStatus,status)
                .update();
    }

    public void supplierProcessBack(List<String> businessNoList, String processStatus) {
        this.lambdaUpdate().eq(TpmMaterialPurchasingOrder::getTenantCode,TenantUtils.getTenantCode())
                .in(TpmMaterialPurchasingOrder::getCode,businessNoList)
                .set(TpmMaterialPurchasingOrder::getProcessStatus,processStatus)
                .update();
    }

    public void updateChangeStatusByCodes(List<TpmMaterialPurchasingOrder> mainOrderList) {
        if(CollectionUtils.isNotEmpty(mainOrderList)){
            mainOrderList.forEach(item->{
                this.lambdaUpdate().set(TpmMaterialPurchasingOrder::getChangeStatus,item.getChangeStatus())
                        .eq(TpmMaterialPurchasingOrder::getCode,item.getCode())
                        .update();
            });
        }
    }

    public List<TpmMaterialPurchasingOrderVo> findByIds(List<String> ids) {
        if(CollectionUtils.isEmpty(ids)){
            return Lists.newArrayList();
        }
        List<TpmMaterialPurchasingOrder> list = this.lambdaQuery().in(TpmMaterialPurchasingOrder::getId, ids)
                .eq(TpmMaterialPurchasingOrder::getTenantCode, TenantUtils.getTenantCode())
                .eq(TpmMaterialPurchasingOrder::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
        if(CollectionUtils.isEmpty(list)){
            return Lists.newArrayList();
        }
        Collection<TpmMaterialPurchasingOrderVo> tpmMaterialPurchasingOrderVos = this.nebulaToolkitService.copyCollectionByWhiteList(list, TpmMaterialPurchasingOrder.class, TpmMaterialPurchasingOrderVo.class, LinkedHashSet.class, ArrayList.class);
        return (List<TpmMaterialPurchasingOrderVo>) tpmMaterialPurchasingOrderVos;
    }

    public void deleteByIds(List<String> ids) {
        if(CollectionUtils.isNotEmpty(ids)){
            this.lambdaUpdate().set(TpmMaterialPurchasingOrder::getDelFlag,DelFlagStatusEnum.DELETE.getCode())
                    .in(TpmMaterialPurchasingOrder::getId,ids)
                    .update();
        }
    }
}

