package com.biz.crm.tpm.business.material.purchasing.order.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheService;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDetailDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderDetailVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * TPM-物料采购单-明细表(TpmMaterialPurchasingOrderDetail)表服务接口
 * @author duyiran
 * @since 2022-11-12 17:56:42
 */
public interface TpmMaterialPurchasingOrderDetailService
        extends MnPageCacheService<TpmMaterialPurchasingOrderDetailVo, TpmMaterialPurchasingOrderDetailDto> {

    /**
     * 根据编码获取详情总数
     * @param code
     * @return
     */
    Integer getTotal(String code);

    /**
     * 根据编码查询所有详情
     * @param code
     * @return
     */
    List<TpmMaterialPurchasingOrderDetailVo> findDetailListByCode(String code);

    /**
     * 根据id集合查询
     * @param ids
     * @return
     */
    List<TpmMaterialPurchasingOrderDetailVo> findByIds(List<String> ids);

    /**
     * 批量更新
     * @param detailVoList
     */
    void updateBatch(List<TpmMaterialPurchasingOrderDetailVo> detailVoList);

    void updateReceivingStatusByCodes(List<String> businessNoList, String value);


    /**
     * 分页查询可以提交审批的明细数据
     * @param pageable
     * @param dto
     * @return
     */
    Page<TpmMaterialPurchasingOrderDetailVo> findSupplierApprovalList(Pageable pageable, TpmMaterialPurchasingOrderDto dto);

    /**
     * 结案核销查看明细数据
     * @param pageable
     * @param dto
     * @return
     */
    Page<TpmMaterialPurchasingOrderDetailVo> auditFindMaterialPurchasingOrderDetailByCondition(Pageable pageable, TpmMaterialPurchasingOrderDetailDto dto);

    Page<TpmMaterialPurchasingOrderDetailVo> findSupplierSubmitApprovalDetailInfo(Pageable pageable, TpmMaterialPurchasingOrderDetailDto dto);

    void generateSignInPdfByCodes(List<String> businessNoList);
}

