package com.biz.crm.tpm.business.material.purchasing.order.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.vo.FileVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.dto.*;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.service.ElectronicSignatureApiService;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.vo.CreateContractVo;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.vo.ElectronicSignatureVo;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderDetail;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderFile;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@Component
public class TpmMaterialPurchasingBaseElectronicSignature {

    /**
     * 文件服务器
     */
    @Autowired(required = false)
    private FileHandleService fileHandleService;

    /**
     * 登录用户服务
     */
    @Autowired(required = false)
    private LoginUserService loginUserService;


    /**
     * 电子签名api服务
     */
    @Autowired(required = false)
    private ElectronicSignatureApiService electronicSignatureApiService;

    /**
     * 数据字典服务
     */
    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Value("${venus.file.fileRoot}")
    public String fileRoot;

    private static final String CATEGORY = "tpm_electronicSignature_category";
    private static final String CATEGORY_ID = "categoryId";
    private static final String CATEGORY_NAME = "categoryName";

    /**
     * 推动电子签章
     */
    public ElectronicSignatureVo<CreateContractVo> pushElectronicSignature(TpmMaterialPurchasingOrderDetail detail, TpmMaterialPurchasingOrderFile orderFile) {

        File mkdir = null;
        try {
            AccountCheckBillDto dto = new AccountCheckBillDto();
            ContractDocumentDto documentDto = new ContractDocumentDto();
            documentDto.setTitle("蒙牛促销物料到货签收单");
            // 获取文件
            OrdinaryFileVo ordinaryFileVo = fileHandleService.findById(orderFile.getFileCode());
            byte[] fileByte = fileHandleService.findContentByFilePathAndFileRename(ordinaryFileVo.getRelativeLocal(),
                    ordinaryFileVo.getFileName());
            mkdir = FileUtil.newFile(fileRoot + "/" + detail.getDetailCode() + ".pdf");
            File file = FileUtil.writeBytes(fileByte, mkdir);
            if (!file.exists()) {
                throw new IllegalArgumentException("文件不存在");
            }
            documentDto.setAccountCheckBillFile(file);
            dto.setContractDocumentDto(documentDto);

            // 合同信息
            ContractDto contractDto = new ContractDto();
            //获取用印流程 配置成数据字典了
            List<DictDataVo> dictTypeCode = this.dictDataVoService.findByDictTypeCode(CATEGORY);
            if (CollectionUtil.isEmpty(dictTypeCode)) {
                throw new IllegalArgumentException("用印流程数据字典不存在");
            }

            DictDataVo categoryIdDict = dictTypeCode.stream().filter(x -> CATEGORY_ID.equals(x.getDictCode()))
                    .findFirst()
                    .orElseThrow(() -> new IllegalArgumentException("数据字典【tpm_electronicSignature_category】不存在用印ID[categoryId]的配置"));
            contractDto.setCategoryId(categoryIdDict.getDictValue());

            DictDataVo categoryNameDict = dictTypeCode.stream().filter(x -> CATEGORY_NAME.equals(x.getDictCode()))
                    .findFirst()
                    .orElseThrow(() -> new IllegalArgumentException("数据字典【tpm_electronicSignature_category】不存在用印名称[categoryName]的配置"));
            contractDto.setCategoryName(categoryNameDict.getDictValue());

            contractDto.setSubject(detail.getDetailCode());
            contractDto.setSn(detail.getDetailCode());
            contractDto.setSend(true);
            contractDto.setExtraSign(false);
            contractDto.setTenantName("内蒙古蒙牛乳业（集团）股份有限公司");
            FacturerUserDetails loginDetails = loginUserService.getLoginDetails(FacturerUserDetails.class);
            contractDto.setCreatorName(loginDetails.getUsername());
            contractDto.setCreatorContact(loginDetails.getPhone());
            contractDto.setMustSign(true);
            contractDto.setCustomerCode(detail.getCustomerCode());

            // 签署人信息
            List<SignatoryDto> signatories = new ArrayList<>();
            SignatoryDto signatoryDto = new SignatoryDto();
            signatoryDto.setTenantType("COMPANY");
            signatoryDto.setTenantName(detail.getCustomerName());
            signatoryDto.setSignatoryNo(detail.getCustomerCode());
            signatoryDto.setReceiverName(detail.getRecipientContacts());
            signatoryDto.setContact(detail.getDeliveryPhone());
            signatoryDto.setSerialNo(1);
            signatoryDto.setRemind(true);
            signatoryDto.setAuthMode("DEFAULT");
            signatoryDto.setLanguage("zh_CN");

            //签署动作
            List<ActionDto> actions = new ArrayList<>();
            ActionDto action1Dto = new ActionDto();
            action1Dto.setSerialNo("1");
            action1Dto.setType("CORPORATE");
            action1Dto.setName("企业签章");
            actions.add(action1Dto);

            ActionDto action2Dto = new ActionDto();
            action2Dto.setSerialNo("1");
            action2Dto.setType("LP");
            action2Dto.setName("法人代表人签字");
            actions.add(action2Dto);

            signatoryDto.setActions(actions);
            signatories.add(signatoryDto);
            contractDto.setSignatories(signatories);

            dto.setContractDto(contractDto);
            return this.electronicSignatureApiService.pushAccountCheckBill(dto);
        } catch (Exception e) {
            log.info("推送电子签章报错啦,{}",ExceptionUtils.getStackTrace(e));
            throw new IllegalArgumentException(e.getMessage(), e);
        } finally {
            if (mkdir != null) {
                mkdir.delete();
            }
        }
    }

    /**
     * 取消电子签章
     *
     * @param detail 对账单vo
     * @return {@link ElectronicSignatureVo}
     */
    public ElectronicSignatureVo cancelElectronicSignature(TpmMaterialPurchasingOrderDetail detail) {
        ScrapContractDto dto = new ScrapContractDto();
        dto.setBizId(detail.getDetailCode());
        dto.setContractId(Long.valueOf(detail.getContractId()));
        return this.electronicSignatureApiService.cancellationContract(dto);
    }

    /**
     * 撤回电子签章
     *
     * @param detail
     * @return {@link ElectronicSignatureVo}
     */
    public ElectronicSignatureVo withdrawalElectronicSignature(TpmMaterialPurchasingOrderDetail detail) {
        WithdrawalContractDto dto = new WithdrawalContractDto();
        dto.setBizId(detail.getDetailCode());
        dto.setContractId(Long.valueOf(detail.getContractId()));
        return this.electronicSignatureApiService.withdrawalContract(dto);
    }

    /**
     * 催签电子签章
     *
     * @param detail 对账单vo
     * @return {@link ElectronicSignatureVo}
     */
    public ElectronicSignatureVo expeditingElectronicSignature(TpmMaterialPurchasingOrderDetail detail) {
        ContractExpeditingDto dto = new ContractExpeditingDto();
        dto.setBizId(detail.getDetailCode());
        dto.setContractId(Long.valueOf(detail.getContractId()));
        return this.electronicSignatureApiService.contractExpediting(dto);
    }

    /**
     * 下载电子签章
     *
     * @param detail 对账单vo
     * @return {@link ElectronicSignatureVo}
     */
    public ElectronicSignatureVo<FileVo> downloadElectronicSignature(TpmMaterialPurchasingOrderDetail detail) {
        DownloadContractDto dto = new DownloadContractDto();
        dto.setBizId(detail.getDetailCode());
        dto.setContractId(Long.valueOf(detail.getContractId()));
        dto.setDocumentId(Long.valueOf(detail.getDocumentsId()));
        return this.electronicSignatureApiService.downloadContract(dto);
    }

}
