package com.biz.crm.tpm.business.material.purchasing.order.local.service.internal;

import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.material.purchasing.order.local.service.TpmMaterialPurchasingOrderAuditInvoiceService;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderAuditInvoiceDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderAuditInvoiceExportVo;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderAuditInvoiceVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * @CLASS_DESCRIBE: 物料采购单发票
 * @AUTHOR: create by zkey on 2023-11-06
 */
@Slf4j
@Service
public class TpmMaterialPurchasingOrderAuditInvoiceServiceImpl
        extends MnPageCacheServiceImpl<TpmMaterialPurchasingOrderAuditInvoiceVo, TpmMaterialPurchasingOrderAuditInvoiceDto>
        implements TpmMaterialPurchasingOrderAuditInvoiceService {

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;


    @Override
    public Integer getTotal(String cacheKey) {
        String key = this.helper.getRedisCacheIdKey(cacheKey);
        return this.redisService.lSize(key).intValue();
    }

    @Override
    public List<TpmMaterialPurchasingOrderAuditInvoiceExportVo> getInvoiceExportData(String cacheKey) {
        List<TpmMaterialPurchasingOrderAuditInvoiceDto> dtos = this.findCacheList(cacheKey);
        if (CollectionUtils.isEmpty(dtos)) return Lists.newArrayListWithCapacity(0);
        return (List<TpmMaterialPurchasingOrderAuditInvoiceExportVo>)
                this.nebulaToolkitService.copyCollectionByWhiteList(dtos,
                                                                    TpmMaterialPurchasingOrderAuditInvoiceDto.class,
                                                                    TpmMaterialPurchasingOrderAuditInvoiceExportVo.class,
                                                                    HashSet.class, ArrayList.class);
    }
}
