package com.biz.crm.tpm.business.material.purchasing.order.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderDetail;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderFile;
import com.biz.crm.tpm.business.material.purchasing.order.local.repository.TpmMaterialPurchasingOrderDetailRepository;
import com.biz.crm.tpm.business.material.purchasing.order.local.repository.TpmMaterialPurchasingOrderFileRepository;
import com.biz.crm.tpm.business.material.purchasing.order.local.service.TpmMaterialPurchasingOrderDetailService;
import com.biz.crm.tpm.business.material.purchasing.order.local.service.TpmMaterialPurchasingOrderPdfService;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDetailDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * TPM-物料采购单-明细表(TpmMaterialPurchasingOrderDetail)表服务实现类
 * @author duyiran
 * @since 2022-11-12 17:56:43
 */
@Slf4j
@Service("tpmMaterialPurchasingOrderDetailService")
public class TpmMaterialPurchasingOrderDetailServiceImpl
        extends MnPageCacheServiceImpl<TpmMaterialPurchasingOrderDetailVo, TpmMaterialPurchasingOrderDetailDto> implements TpmMaterialPurchasingOrderDetailService {

    @Autowired
    private TpmMaterialPurchasingOrderDetailRepository detailRepository;

    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private TpmMaterialPurchasingOrderPdfService pdfService;

    @Autowired(required = false)
    private TpmMaterialPurchasingOrderFileRepository fileRepository;

    @Override
    public Integer getTotal(String cacheKey) {
        String key = this.helper.getRedisCacheIdKey(cacheKey);
        return this.redisService.lSize(key).intValue();
    }

    @Override
    public List<TpmMaterialPurchasingOrderDetailVo> findDetailListByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return Lists.newArrayList();
        }
        List<TpmMaterialPurchasingOrderDetail> detailList = this.detailRepository.findDetailListByCode(code);
        if (CollectionUtils.isEmpty(detailList)) {
            return Lists.newArrayList();
        }
        return (List<TpmMaterialPurchasingOrderDetailVo>) this.nebulaToolkitService.copyCollectionByWhiteList(detailList, TpmMaterialPurchasingOrderDetail.class, TpmMaterialPurchasingOrderDetailVo.class, HashSet.class, ArrayList.class);
    }

    @Override
    public List<TpmMaterialPurchasingOrderDetailVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<TpmMaterialPurchasingOrderDetail> list = this.detailRepository.listByIds(ids);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List<TpmMaterialPurchasingOrderDetailVo>) this.nebulaToolkitService.copyCollectionByWhiteList(list, TpmMaterialPurchasingOrderDetail.class, TpmMaterialPurchasingOrderDetailVo.class, HashSet.class, ArrayList.class);
    }

    @Override
    public void updateBatch(List<TpmMaterialPurchasingOrderDetailVo> detailVoList) {
        if (CollectionUtils.isEmpty(detailVoList)) {
            return;
        }
        List<TpmMaterialPurchasingOrderDetail> list = (List<TpmMaterialPurchasingOrderDetail>) this.nebulaToolkitService.copyCollectionByWhiteList(detailVoList, TpmMaterialPurchasingOrderDetailVo.class, TpmMaterialPurchasingOrderDetail.class, HashSet.class, ArrayList.class);
        this.detailRepository.updateBatchById(list);
    }

    @Override
    @Transactional
    public void updateReceivingStatusByCodes(List<String> businessNoList, String status) {
        if (CollectionUtils.isEmpty(businessNoList)) return;
        this.detailRepository.updateReceivingStatusByCodes(businessNoList, status);
    }

    /**
     * 分页查询可以提交审批的明细数据
     * @param pageable
     * @param dto
     * @return
     */
    @Override
    public Page<TpmMaterialPurchasingOrderDetailVo> findSupplierApprovalList(Pageable pageable, TpmMaterialPurchasingOrderDto dto) {
        return this.detailRepository.findSupplierApprovalList(pageable,dto);
    }

    @Override
    public Page<TpmMaterialPurchasingOrderDetailVo> auditFindMaterialPurchasingOrderDetailByCondition(Pageable pageable, TpmMaterialPurchasingOrderDetailDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new TpmMaterialPurchasingOrderDetailDto();
        }
        return this.detailRepository.auditFindMaterialPurchasingOrderDetailByCondition(pageable,dto);
    }

    @Override
    public Page<TpmMaterialPurchasingOrderDetailVo> findSupplierSubmitApprovalDetailInfo(Pageable pageable, TpmMaterialPurchasingOrderDetailDto dto) {

        return this.detailRepository.findSupplierSubmitApprovalDetailInfo(pageable,dto);
    }

    @Override
    public void generateSignInPdfByCodes(List<String> codes) {
        if(CollectionUtils.isEmpty(codes)){
            return;
        }
        List<TpmMaterialPurchasingOrderDetail> detailList = this.detailRepository.findByCodeList(codes);
        if(CollectionUtils.isEmpty(detailList)){
            return;
        }
        log.info("采购单确认通过：detailList：{}", JsonUtils.obj2JsonString(detailList));
        // 生成PDF文件并保存
        List<TpmMaterialPurchasingOrderFile> fileList = Lists.newArrayList();
        detailList.forEach(detail->{
            TpmMaterialPurchasingOrderFile file = pdfService.outConfirmPdf(detail);
            try {
                Thread.sleep(2000);
            } catch (InterruptedException e) {
                log.info("睡不着了,{}", ExceptionUtils.getStackTrace(e));
            }
            fileList.add(file);
        });

        log.info("采购单确认通过：detailList：{}", JsonUtils.obj2JsonString(fileList));
        List<String> detailCodes = detailList.stream().map(TpmMaterialPurchasingOrderDetail::getDetailCode).collect(Collectors.toList());
        this.fileRepository.deleteByBusinessCodes(detailCodes);
        this.fileRepository.saveBatch(fileList);
    }
}

